% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_match_dataset}
\alias{data_dict_match_dataset}
\title{Inner join between a dataset and its associated data dictionary}
\usage{
data_dict_match_dataset(
  dataset,
  data_dict,
  data_dict_apply = FALSE,
  output = c("dataset", "data_dict")
)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations.}

\item{data_dict}{A list of tibble(s) representing meta data.}

\item{data_dict_apply}{whether to apply the data dictionary to its dataset.
The resulting tibble will have for each column its associated meta data as
attributes. The factors will be preserved. FALSE by default.}

\item{output}{A vector of character string which indicates if the function
returns a dataset ('dataset'), data dictionary ('data_dict') of both.
Default is c('dataset','data_dict').}
}
\value{
Either a tibble, identifying the dataset, or a list of tibble(s)
identifying a data dictionary. Returns both in a list by default.
}
\description{
Performs an inner join between a dataset and its associated data dictionary,
keeping only variables present in both. This function returns the matched
dataset rows, the matched data dictionary rows, or both, in a list.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package
library(dplyr)
dataset <- DEMO_files$dataset_MELBOURNE_1 \%>\% select(-1)
data_dict <- DEMO_files$dd_MELBOURNE_1_format_maelstrom
data_dict_match_dataset(dataset, data_dict)

}

}
