% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental.R
\name{is_category}
\alias{is_category}
\title{Test if an object is a valid dataset}
\usage{
is_category(x, threshold = NULL)
}
\arguments{
\item{x}{object to be coerced.}

\item{threshold}{Optional. The function returns TRUE if the number of unique
values in the input vector is lower.}
}
\value{
A logical.
}
\description{
Tests if the input object is a valid dataset. This function mainly helps
validate input within other functions of the package but could be used
to check if a dataset is valid.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Test if vector object is a categorical variable, typically a column in a
data frame. This function mainly helps validate input within other functions
of the package.
}
\examples{
{

library(dplyr)
iris \%>\% summarise(across(everything(), is_category))
is_category(iris[['Species']])

}

}
