% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSets.R
\name{getSets}
\alias{getSets}
\alias{getSets<-}
\alias{getSets<-}
\title{Get sets}
\usage{
getSets(x, fulldim = TRUE, sep = ".")

getSets(x, fulldim = TRUE, sep = ".") <- value
}
\arguments{
\item{x}{MAgPIE object}

\item{fulldim}{bool: Consider dimension 3 as a possible aggregate of more
dimensions (TRUE) or stick to it as one dimension (FALSE)}

\item{sep}{A character separating joined dimension names}

\item{value}{A vector with set names you want to replace the current set
names of the object with.}
}
\value{
Sets of the MAgPIE-object. If no information about contained sets is
available NULL
}
\description{
Extracts sets of a MAgPIE-object if available
}
\section{Functions}{
\itemize{
\item \code{getSets<-}: replace set names
}}

\examples{

 a <- new.magpie("GLO.1",2000,c("a.o1","b.o1","a.o2"))
 getSets(a) <- c("reg","cell","t","bla","blub")
 getSets(a)
 
 getSets(a)[4] <- "BLA"
 getSets(a,fulldim=FALSE)
 getSets(a)

}
\seealso{
\code{\link{getRegions}},
\code{\link{getNames}},\code{\link{getYears}}, \code{\link{getCPR}},
\code{\link{read.magpie}}, \code{\link{write.magpie}},
\code{"\linkS4class{magpie}"}
}
\author{
Markus Bonsch
}
