% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{composite}
\alias{composite}
\alias{image_composite}
\title{Magick Composite}
\usage{
image_composite(image, composite_image = image[1], operator = "atop",
  offset = "0x0", compose_args = "")
}
\arguments{
\item{image}{object returned by \code{image_read}}

\item{composite_image}{composition image}

\item{operator}{string with a
\href{https://www.imagemagick.org/Magick++/Enumerations.html#CompositeOperator}{composite operator}.}

\item{offset}{geometry string with offset}

\item{compose_args}{additional arguments needed for some composite operations}
}
\description{
Similar to the ImageMagick `composite` command.
}
\examples{
# Compose images using one of many operators
imlogo <- image_scale(image_read("logo:"), "x275")
rlogo <- image_read("https://developer.r-project.org/Logo/Rlogo-3.png")
image_composite(imlogo, rlogo)
image_composite(imlogo, rlogo, operator = "blend", compose_args="50")
}
