% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_quantize.R
\name{interactive_quantize}
\alias{interactive_quantize}
\title{interactive quantization}
\usage{
interactive_quantize(image, colorspace = "rgb", dither = NULL,
  treedepth = NULL, range_max = 256, resolution = 1,
  return_param = FALSE)
}
\arguments{
\item{image}{a magick image object}

\item{colorspace}{specify colorspace. for example, "rgb", "gray", or "cmyk".}

\item{dither}{apply Floyd/Steinberg error diffusion to the image}

\item{treedepth}{depth of the quantization color classification tree}

\item{range_max}{define maximum in slider. must be positive.}

\item{resolution}{resolution of slider}

\item{return_param}{if TRUE, returns value of max. if FALSE, returns magick image object.}
}
\value{
magick a image object or value of max
}
\description{
Using image_quantize of 'magick' interactively.
max, colorspace, dither, and treedepth are parameters of image_quantize. see reference manual of 'magick' for detail.
}
\examples{
\donttest{
interactive_quantize(wizard)
}
}
\author{
Shota Ochi
}
