% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weighted_twt}
\alias{weighted_twt}
\title{Weighted object for two arm trial data}
\format{
A \code{maicplus_estimate_weights} object created by \code{\link[=estimate_weights]{estimate_weights()}} containing
\describe{
\item{data}{patient level data with weights}
\item{centered_colnames}{Columns used in MAIC}
\item{nr_missing}{Number of observations with missing data}
\item{ess}{Expected sample size}
\item{opt}{Information from \code{optim} from weight calculation}
\item{boot}{Parameters and bootstrap sample weights for the 100 samples}
}
}
\usage{
weighted_twt
}
\description{
The weighted patient data for a two arm trial generated from the centered patient data (\link{centered_ipd_twt}).
It has weights calculated for 100 bootstrap samples.

The object is generated using the following code:

\if{html}{\out{<div class="sourceCode">}}\preformatted{estimate_weights(
  data = centered_ipd_twt,
  centered_colnames = c(
    "AGE_CENTERED",
    "AGE_MEDIAN_CENTERED",
    "AGE_SQUARED_CENTERED",
    "SEX_MALE_CENTERED",
    "ECOG0_CENTERED",
    "SMOKE_CENTERED"
    ),
  n_boot_iteration = 100
 )
}\if{html}{\out{</div>}}
}
\seealso{
Other anchored datasets: 
\code{\link{adrs_twt}},
\code{\link{adsl_twt}},
\code{\link{adtte_twt}},
\code{\link{agd}},
\code{\link{centered_ipd_twt}},
\code{\link{pseudo_ipd_twt}}
}
\concept{anchored datasets}
\keyword{dataset}
