% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{plot_weights_base}
\alias{plot_weights_base}
\title{Plot MAIC weights in a histogram with key statistics in legend}
\usage{
plot_weights_base(
  weighted_data,
  bin_col,
  vline_col,
  main_title,
  scaled_weights
)
}
\arguments{
\item{weighted_data}{object returned after calculating weights using \link{estimate_weights}}

\item{bin_col}{a string, color for the bins of histogram}

\item{vline_col}{a string, color for the vertical line in the histogram}

\item{main_title}{title of the plot}

\item{scaled_weights}{an indicator for using scaled weights instead of regular weights}
}
\value{
a plot of unscaled or scaled weights
}
\description{
Generates a base R histogram of weights. Default is to plot either unscaled or scaled weights and not both.
}
\examples{
plot_weights_base(weighted_sat,
  bin_col = "#6ECEB2",
  vline_col = "#688CE8",
  main_title = c("Scaled Individual Weights", "Unscaled Individual Weights"),
  scaled_weights = TRUE
)
}
