% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{extract_posterior_effect}
\alias{extract_posterior_effect}
\title{Extract the posterior of a random effect}
\usage{
extract_posterior_effect(obj, effname)
}
\arguments{
\item{obj}{An object from \code{inference_stan}.}

\item{effname}{Name of the random effect, same name as in the data.}
}
\value{
Returns a matrix with the posterior samples of the chosen effect
}
\description{
Extract the posterior of a random effect in the model for inference done with Stan
}
\examples{

if (interactive() && requireNamespace("rstan")){
  ex_prior <- makemyprior_example_model()
  res_stan <- inference_stan(ex_prior, iter = 100)
  # Note: For reliable results, increase the number of iterations (e.g., 'iter = 2000')
  extract_posterior_effect(res_stan, "a")
}

}
\keyword{posterior}
