/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongLongIterator;
import gnu.trove.TLongLongProcedure;
import gnu.trove.TLongProcedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class TLongLongHashMap
extends TLongHash
implements Externalizable {
    static final long serialVersionUID = 1L;
    protected transient long[] _values;

    public TLongLongHashMap() {
    }

    public TLongLongHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TLongLongHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TLongLongHashMap(TLongHashingStrategy strategy) {
        super(strategy);
    }

    public TLongLongHashMap(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TLongLongHashMap(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TLongLongHashMap m = (TLongLongHashMap)super.clone();
        m._values = (long[])this._values.clone();
        return m;
    }

    public TLongLongIterator iterator() {
        return new TLongLongIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new long[capacity];
        return capacity;
    }

    public long put(long key, long value) {
        long previous = 0L;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        long[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new long[newCapacity];
        this._values = new long[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            long o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public long get(long key) {
        int index = this.index(key);
        return index < 0 ? 0L : this._values[index];
    }

    public void clear() {
        super.clear();
        long[] keys = this._set;
        long[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0L;
            vals[i] = 0L;
            states[i] = 0;
        }
    }

    public long remove(long key) {
        long prev = 0L;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongLongHashMap)) {
            return false;
        }
        TLongLongHashMap that = (TLongLongHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        this._values[index] = 0L;
        super.removeAt(index);
    }

    public long[] getValues() {
        long[] vals = new long[this.size()];
        long[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public long[] keys() {
        long[] keys = new long[this.size()];
        long[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public long[] keys(long[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (long[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        long[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == 0L || k[i] == 2L) continue;
            a[j++] = k[i];
        }
        return a;
    }

    public boolean containsValue(long val) {
        byte[] states = this._states;
        long[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongLongProcedure procedure) {
        byte[] states = this._states;
        long[] keys = this._set;
        long[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TLongLongProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        long[] keys = this._set;
        long[] values = this._values;
        this.tempDisableAutoCompaction();
        try {
            int i = keys.length;
            while (i-- > 0) {
                if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.reenableAutoCompaction(true);
        }
        return modified;
    }

    public void transformValues(TLongFunction function) {
        byte[] states = this._states;
        long[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(long key) {
        return this.adjustValue(key, 1L);
    }

    public boolean adjustValue(long key, long amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    public long adjustOrPutValue(long key, long adjust_amount, long put_amount) {
        boolean isNewMapping;
        long newValue;
        int index = this.insertionIndex(key);
        if (index < 0) {
            int n = index = -index - 1;
            long l = this._values[n] + adjust_amount;
            this._values[n] = l;
            newValue = l;
            isNewMapping = false;
        } else {
            newValue = this._values[index] = put_amount;
            isNewMapping = true;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return newValue;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(out);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        int size = in.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = in.readLong();
            long val = in.readLong();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TLongLongProcedure {
        private final TLongLongHashMap _otherMap;

        EqProcedure(TLongLongHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(long key, long value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(long v1, long v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TLongLongProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long key, long value) {
            this.h += TLongLongHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

