/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TDoubleShortHashMap;
import gnu.trove.TDoubleShortIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleShortHashMapDecorator
extends AbstractMap<Double, Short>
implements Map<Double, Short>,
Cloneable {
    protected TDoubleShortHashMap _map;

    public TDoubleShortHashMapDecorator(TDoubleShortHashMap map) {
        this._map = map;
    }

    public TDoubleShortHashMap getMap() {
        return this._map;
    }

    @Override
    public TDoubleShortHashMapDecorator clone() {
        try {
            TDoubleShortHashMapDecorator copy = (TDoubleShortHashMapDecorator)super.clone();
            copy._map = (TDoubleShortHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Short put(Double key, Short value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Double && val instanceof Short) {
                    double k = this.unwrapKey(key);
                    short v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Short get(Double key) {
        double k = this.unwrapKey(key);
        short v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Short remove(Double key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Double, Short>> entrySet() {
        return new AbstractSet<Map.Entry<Double, Short>>(){

            @Override
            public int size() {
                return TDoubleShortHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TDoubleShortHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TDoubleShortHashMapDecorator.this.containsKey(k) && ((Short)TDoubleShortHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Double, Short>> iterator() {
                return new Iterator<Map.Entry<Double, Short>>(){
                    private final TDoubleShortIterator it;
                    {
                        this.it = TDoubleShortHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Double, Short> next() {
                        this.it.advance();
                        final Double key = TDoubleShortHashMapDecorator.this.wrapKey(this.it.key());
                        final Short v = TDoubleShortHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Double, Short>(){
                            private Short val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Double getKey() {
                                return key;
                            }

                            @Override
                            public Short getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Short setValue(Short value) {
                                this.val = value;
                                return TDoubleShortHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Short o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Double, Short>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TDoubleShortHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Short> map) {
        Iterator<Map.Entry<? extends Double, ? extends Short>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Double, ? extends Short> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Double wrapKey(double k) {
        return new Double(k);
    }

    protected double unwrapKey(Object key) {
        return (Double)key;
    }

    protected Short wrapValue(short k) {
        return new Short(k);
    }

    protected short unwrapValue(Object value) {
        return (Short)value;
    }
}

