/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.javax.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class GeneralPathPanel
extends JPanel {
    private JScrollPane scroller;
    private GeneralPath gPath;
    private Color outlineColor;
    private Color selectedColor;
    private Vector segmentVector = new Vector();
    private ArrayList generalPathList;
    private int selectedSegment;
    private boolean firstPaint = true;
    public static final int MINIMUM_WIDTH = 320;
    public static final int MINIMUM_HEIGHT = 120;

    public GeneralPathPanel(GeneralPath gPath, Color outlineColor) {
        this.gPath = gPath;
        this.setPreferredSize(this.getGeneralPathDimension());
        this.setMinimumSize(new Dimension(320, 120));
        this.generalPathList = this.createGeneralPaths(gPath);
        this.setBackground(Color.white);
        this.setVisible(true);
        this.outlineColor = outlineColor;
        this.selectedColor = outlineColor.darker();
    }

    public void setGeneralPath(GeneralPath newGPath) {
        this.gPath = newGPath;
        this.setPreferredSize(this.getGeneralPathDimension());
        this.generalPathList = this.createGeneralPaths(this.gPath);
        this.firstPaint = true;
        this.revalidate();
        this.repaint();
    }

    public void setOutlineColor(Color newOutlineColor) {
        this.outlineColor = newOutlineColor;
        this.selectedColor = this.outlineColor.darker();
    }

    public void setScrollPane(JScrollPane scroller) {
        this.scroller = scroller;
    }

    private ArrayList createGeneralPaths(GeneralPath gPath) {
        ArrayList<GeneralPath> listOfPaths = new ArrayList<GeneralPath>();
        GeneralPath segmentPath = null;
        PathIterator iterator = gPath.getPathIterator(null);
        float[] segments = new float[6];
        float x1 = 0.0f;
        float y1 = 0.0f;
        float firstX = 0.0f;
        float firstY = 0.0f;
        boolean firstPoint = true;
        this.segmentVector = new Vector();
        while (!iterator.isDone()) {
            int currSegment = iterator.currentSegment(segments);
            if (firstPoint) {
                firstX = segments[0];
                firstY = segments[1];
                firstPoint = false;
            }
            switch (currSegment) {
                case 0: {
                    segmentPath = new GeneralPath();
                    segmentPath.moveTo(segments[0], segments[1]);
                    this.segmentVector.add("SEG_MOVETO");
                    x1 = segments[0];
                    y1 = segments[1];
                    break;
                }
                case 1: {
                    segmentPath = new GeneralPath();
                    segmentPath.moveTo(x1, y1);
                    segmentPath.lineTo(segments[0], segments[1]);
                    this.segmentVector.add("SEG_LINETO");
                    x1 = segments[0];
                    y1 = segments[1];
                    break;
                }
                case 2: {
                    segmentPath = new GeneralPath();
                    segmentPath.moveTo(x1, y1);
                    segmentPath.quadTo(segments[0], segments[1], segments[2], segments[3]);
                    this.segmentVector.add("SEG_QUADTO");
                    x1 = segments[2];
                    y1 = segments[3];
                    break;
                }
                case 3: {
                    segmentPath = new GeneralPath();
                    segmentPath.moveTo(x1, y1);
                    segmentPath.curveTo(segments[0], segments[1], segments[2], segments[3], segments[4], segments[5]);
                    this.segmentVector.add("SEG_CUBICTO");
                    x1 = segments[4];
                    y1 = segments[5];
                    break;
                }
                case 4: {
                    segmentPath = new GeneralPath();
                    segmentPath.moveTo(x1, y1);
                    segmentPath.lineTo(firstX, firstY);
                    this.segmentVector.add("SEG_CLOSE");
                    x1 = firstX;
                    y1 = firstY;
                }
            }
            listOfPaths.add(segmentPath);
            iterator.next();
        }
        return listOfPaths;
    }

    public Vector getSegmentVector() {
        return this.segmentVector;
    }

    public void setSelectedSegment(int segmentIndex) {
        this.selectedSegment = segmentIndex;
    }

    public Dimension getGeneralPathDimension() {
        Rectangle2D bounds = this.gPath.getBounds2D();
        return new Dimension((int)bounds.getWidth() + 10, (int)bounds.getHeight() + 10);
    }

    public void paint(Graphics g) {
        AffineTransform transform = new AffineTransform();
        Rectangle2D bounds = this.gPath.getBounds2D();
        boolean width = false;
        boolean height = false;
        if (this.firstPaint) {
            JComponent componentToAlignWith = this.scroller == null ? this : this.scroller;
            double newX = (double)componentToAlignWith.getWidth() > bounds.getWidth() ? ((double)componentToAlignWith.getWidth() - bounds.getWidth()) / 2.0 : 5.0;
            double xTransform = newX - bounds.getX();
            double newY = (double)componentToAlignWith.getHeight() > bounds.getHeight() ? ((double)componentToAlignWith.getHeight() - bounds.getHeight()) / 2.0 : 5.0;
            double yTransform = newY - bounds.getY();
            transform.setToTranslation(xTransform, yTransform);
        }
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.outlineColor);
        Stroke origStroke = g2d.getStroke();
        for (int i = 0; i < this.generalPathList.size(); ++i) {
            GeneralPath segmentPath = (GeneralPath)this.generalPathList.get(i);
            if (this.firstPaint) {
                segmentPath.transform(transform);
            }
            if (i == this.selectedSegment) {
                BasicStroke newStroke = new BasicStroke(new BasicStroke().getLineWidth() * 2.0f);
                g2d.setStroke(newStroke);
                g2d.setColor(this.selectedColor);
            }
            g2d.draw(segmentPath);
            if (i != this.selectedSegment) continue;
            g2d.setStroke(origStroke);
            g2d.setColor(this.outlineColor);
        }
        this.firstPaint = false;
    }
}

