/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference.gbp;

import cc.mallet.grmm.inference.gbp.Region;
import cc.mallet.grmm.inference.gbp.RegionGraph;
import cc.mallet.grmm.inference.gbp.RegionGraphGenerator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.Variable;
import java.util.Iterator;

public class BPRegionGenerator
implements RegionGraphGenerator {
    @Override
    public RegionGraph constructRegionGraph(FactorGraph mdl) {
        RegionGraph rg = new RegionGraph();
        Iterator it = mdl.factorsIterator();
        while (it.hasNext()) {
            Factor ptl = (Factor)it.next();
            if (ptl.varSet().size() == 1) continue;
            Region parent = new Region(ptl);
            for (Variable var : ptl.varSet()) {
                Factor childPtl = mdl.factorOf(var);
                Region child = rg.findRegion(childPtl, true);
                if (childPtl != null) {
                    parent.addFactor(childPtl);
                    child.addFactor(childPtl);
                }
                rg.add(parent, child);
            }
        }
        rg.computeInferenceCaches();
        return rg;
    }
}

