/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.optimize.tests;

import cc.mallet.optimize.ConjugateGradient;
import cc.mallet.optimize.GradientAscent;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.OrthantWiseLimitedMemoryBFGS;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOptimizer
extends TestCase {
    public TestOptimizer(String name) {
        super(name);
    }

    public void testGradientAscent() {
        SimplePoly poly = new SimplePoly();
        GradientAscent gd = new GradientAscent(poly);
        gd.optimize();
        TestOptimizer.assertEquals((double)0.8333333333333334, (double)poly.params[0], (double)0.001);
    }

    public void testLinearLBFGS() {
        SimplePoly poly = new SimplePoly();
        LimitedMemoryBFGS bfgs = new LimitedMemoryBFGS(poly);
        bfgs.optimize();
        TestOptimizer.assertEquals((double)0.8333333333333334, (double)poly.params[0], (double)0.001);
    }

    public void testOrthantWiseLBFGSWithoutL1() {
        SimplePoly poly = new SimplePoly();
        OrthantWiseLimitedMemoryBFGS bfgs = new OrthantWiseLimitedMemoryBFGS(poly);
        bfgs.optimize();
        TestOptimizer.assertEquals((double)0.8333333333333334, (double)poly.params[0], (double)0.001);
    }

    public void testOrthantWiseLBFGSWithL1() {
        SimplePoly poly = new SimplePoly();
        OrthantWiseLimitedMemoryBFGS bfgs = new OrthantWiseLimitedMemoryBFGS(poly, 3.0);
        bfgs.optimize();
        TestOptimizer.assertEquals((double)0.3333333333333333, (double)poly.params[0], (double)0.001);
    }

    public void testConjugateGradient() {
        SimplePoly poly = new SimplePoly();
        ConjugateGradient cg = new ConjugateGradient(poly);
        cg.optimize();
        TestOptimizer.assertEquals((double)0.8333333333333334, (double)poly.params[0], (double)0.001);
    }

    public static TestSuite suite() {
        return new TestSuite(TestOptimizer.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOptimizer.suite());
    }

    static class SimplePoly
    implements Optimizable.ByGradientValue {
        double[] params = new double[1];

        SimplePoly() {
        }

        @Override
        public void getParameters(double[] doubleArray) {
            doubleArray[0] = this.params[0];
        }

        @Override
        public int getNumParameters() {
            return 1;
        }

        @Override
        public double getParameter(int n) {
            return this.params[0];
        }

        @Override
        public void setParameters(double[] doubleArray) {
            this.params[0] = doubleArray[0];
        }

        @Override
        public void setParameter(int n, double d) {
            this.params[n] = d;
        }

        @Override
        public double getValue() {
            System.out.println("param = " + this.params[0] + " value = " + (-3.0 * this.params[0] * this.params[0] + 5.0 * this.params[0] - 2.0));
            return -3.0 * this.params[0] * this.params[0] + 5.0 * this.params[0] - 2.0;
        }

        @Override
        public void getValueGradient(double[] buffer) {
            buffer[0] = -6.0 * this.params[0] + 5.0;
        }
    }
}

