/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

public final class Maths {
    public static double EPSILON = 1.0E-6;
    public static final double log2 = Math.log(2.0);
    private static final double LOGTOLERANCE = 30.0;

    public static final double logGamma(double x) {
        double result;
        double d1 = -0.5772156649015329;
        double[] p1 = new double[]{4.945235359296727, 201.8112620856775, 2290.8383738313464, 11319.672059033808, 28557.246356716354, 38484.962284437934, 26377.487876241954, 7225.813979700288};
        double[] q1 = new double[]{67.48212550303778, 1113.3323938571993, 7738.757056935398, 27639.870744033407, 54993.102062261576, 61611.22180066002, 36351.2759150194, 8785.536302431014};
        double d2 = 0.42278433509846713;
        double[] p2 = new double[]{4.974607845568932, 542.4138599891071, 15506.93864978365, 184793.29044456323, 1088204.7694688288, 3338152.96798703, 5106661.678927353, 3074109.0548505397};
        double[] q2 = new double[]{183.03283993705926, 7765.049321445006, 133190.38279660742, 1136705.8213219696, 5267964.117437947, 1.3467014543111017E7, 1.7827365303532742E7, 9533095.591844354};
        double d4 = 1.791759469228055;
        double[] p4 = new double[]{14745.0216605994, 2426813.3694867045, 1.2147555740450932E8, 2.663432449630977E9, 2.940378956634554E10, 1.702665737765399E11, 4.926125793377431E11, 5.606251856223951E11};
        double[] q4 = new double[]{2690.5301758708993, 639388.5654300093, 4.135599930241388E7, 1.120872109616148E9, 1.4886137286788137E10, 1.0168035862724382E11, 3.4174763455073773E11, 4.463158187419713E11};
        double[] c = new double[]{-0.001910444077728, 8.4171387781295E-4, -5.952379913043012E-4, 7.936507935003503E-4, -0.0027777777777776816, 0.08333333333333333, 0.0057083835261};
        double a = 0.6796875;
        if (x <= 0.5 || x > 0.6796875 && x <= 1.5) {
            if (x <= 0.5) {
                result = -Math.log(x);
                if (x + 1.0 == 1.0) {
                    return result;
                }
            } else {
                result = 0.0;
                x = x - 0.5 - 0.5;
            }
            double xnum = 0.0;
            double xden = 1.0;
            for (int i = 0; i < 8; ++i) {
                xnum = xnum * x + p1[i];
                xden = xden * x + q1[i];
            }
            result += x * (-0.5772156649015329 + x * (xnum / xden));
        } else if (x <= 0.6796875 || x > 1.5 && x <= 4.0) {
            if (x <= 0.6796875) {
                result = -Math.log(x);
                x = x - 0.5 - 0.5;
            } else {
                result = 0.0;
                x -= 2.0;
            }
            double xnum = 0.0;
            double xden = 1.0;
            for (int i = 0; i < 8; ++i) {
                xnum = xnum * x + p2[i];
                xden = xden * x + q2[i];
            }
            result += x * (0.42278433509846713 + x * (xnum / xden));
        } else if (x <= 12.0) {
            x -= 4.0;
            double xnum = 0.0;
            double xden = -1.0;
            for (int i = 0; i < 8; ++i) {
                xnum = xnum * x + p4[i];
                xden = xden * x + q4[i];
            }
            result = 1.791759469228055 + x * (xnum / xden);
        } else {
            double y = Math.log(x);
            result = x * (y - 1.0) - y * 0.5 + 0.9189385332046728;
            x = 1.0 / x;
            y = x * x;
            double xnum = c[6];
            for (int i = 0; i < 6; ++i) {
                xnum = xnum * y + c[i];
            }
            result += (xnum *= x);
        }
        return result;
    }

    public static double oldLogGamma(double x) {
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double y = x;
        double tmp = x + 5.5 - (x + 0.5) * Math.log(x + 5.5);
        double ser = 1.000000000190015;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (y += 1.0);
        }
        return Math.log(2.5066282746310007 * ser / x) - tmp;
    }

    public static double logBeta(double a, double b) {
        return Maths.logGamma(a) + Maths.logGamma(b) - Maths.logGamma(a + b);
    }

    public static double beta(double a, double b) {
        return Math.exp(Maths.logBeta(a, b));
    }

    public static double gamma(double x) {
        return Math.exp(Maths.logGamma(x));
    }

    public static double factorial(int n) {
        return Math.exp(Maths.logGamma(n + 1));
    }

    public static double logFactorial(int n) {
        return Maths.logGamma(n + 1);
    }

    public static double logBinom(int x, int n, double p) {
        return Maths.logFactorial(n) - Maths.logFactorial(x) - Maths.logFactorial(n - x) + (double)x * Math.log(p) + (double)(n - x) * Math.log(1.0 - p);
    }

    public static double pbinom(int x, int n, double p) {
        double sum = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= x; ++i) {
            sum = Maths.sumLogProb(sum, Maths.logBinom(i, n, p));
        }
        return Math.exp(sum);
    }

    public static double sigmod(double beta) {
        return 1.0 / (1.0 + Math.exp(-beta));
    }

    public static double sigmod_rev(double sig) {
        return Math.log(sig / (1.0 - sig));
    }

    public static double logit(double p) {
        return Math.log(p / (1.0 - p));
    }

    public static double numCombinations(int n, int r) {
        return Math.exp(Maths.logFactorial(n) - Maths.logFactorial(r) - Maths.logFactorial(n - r));
    }

    public static double numPermutations(int n, int r) {
        return Math.exp(Maths.logFactorial(n) - Maths.logFactorial(r));
    }

    public static double cosh(double a) {
        if (a < 0.0) {
            return 0.5 * (Math.exp(-a) + Math.exp(a));
        }
        return 0.5 * (Math.exp(a) + Math.exp(-a));
    }

    public static double tanh(double a) {
        return (Math.exp(a) - Math.exp(-a)) / (Math.exp(a) + Math.exp(-a));
    }

    public static boolean almostEquals(double d1, double d2) {
        return Maths.almostEquals(d1, d2, EPSILON);
    }

    public static boolean almostEquals(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) < epsilon;
    }

    public static boolean almostEquals(double[] d1, double[] d2, double eps) {
        for (int i = 0; i < d1.length; ++i) {
            double v1 = d1[i];
            double v2 = d2[i];
            if (Maths.almostEquals(v1, v2, eps)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkWithinRange(double value, double min, double max) {
        return (value > min || Maths.almostEquals(value, min, EPSILON)) && (value < max || Maths.almostEquals(value, max, EPSILON));
    }

    public static double klDivergence(double[] p1, double[] p2) {
        assert (p1.length == p2.length);
        double klDiv = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            if (p1[i] == 0.0) continue;
            if (p2[i] == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            klDiv += p1[i] * Math.log(p1[i] / p2[i]);
        }
        return klDiv / log2;
    }

    public static double jensenShannonDivergence(double[] p1, double[] p2) {
        assert (p1.length == p2.length);
        double[] average = new double[p1.length];
        for (int i = 0; i < p1.length; ++i) {
            int n = i;
            average[n] = average[n] + (p1[i] + p2[i]) / 2.0;
        }
        return (Maths.klDivergence(p1, average) + Maths.klDivergence(p2, average)) / 2.0;
    }

    public static double sumLogProb(double a, double b) {
        if (a == Double.NEGATIVE_INFINITY) {
            return b;
        }
        if (b == Double.NEGATIVE_INFINITY) {
            return a;
        }
        if (b < a) {
            return a + Math.log(1.0 + Math.exp(b - a));
        }
        return b + Math.log(1.0 + Math.exp(a - b));
    }

    public static double sumLogProb(double[] vals) {
        int i;
        double max = Double.NEGATIVE_INFINITY;
        int len = vals.length;
        int maxidx = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!(vals[i2] > max)) continue;
            max = vals[i2];
            maxidx = i2;
        }
        boolean anyAdded = false;
        double intermediate = 0.0;
        double cutoff = max - 30.0;
        for (i = 0; i < maxidx; ++i) {
            if (!(vals[i] >= cutoff)) continue;
            anyAdded = true;
            intermediate += Math.exp(vals[i] - max);
        }
        for (i = maxidx + 1; i < len; ++i) {
            if (!(vals[i] >= cutoff)) continue;
            anyAdded = true;
            intermediate += Math.exp(vals[i] - max);
        }
        if (anyAdded) {
            return max + Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static double subtractLogProb(double a, double b) {
        if (b == Double.NEGATIVE_INFINITY) {
            return a;
        }
        return a + Math.log(1.0 - Math.exp(b - a));
    }

    public static double getEntropy(double[] dist) {
        double entropy = 0.0;
        for (int i = 0; i < dist.length; ++i) {
            if (dist[i] == 0.0) continue;
            entropy -= dist[i] * Math.log(dist[i]);
        }
        return entropy;
    }
}

