% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{rbfunc}
\alias{rbfunc}
\title{Radial Basis Function}
\usage{
rbfunc(imagedim, seppix, hispec = FALSE, mask = NULL)
}
\arguments{
\item{imagedim}{a vector indicating image three dimension.}

\item{seppix}{a numeric. distance between knots.}

\item{hispec}{a logical. TRUE produces a matrix output. FALSE produces a list output to reduce the data memorry.}

\item{mask}{a vector.}
}
\description{
This makes a radial basis function.
}
\details{
\code{rbfunc} requires the dimensions of the original image to be applied and the knot interval. The output is obtained as a matrix, with the number of rows corresponding to the number of voxels in the original image and the number of columns determined by the knot spacing. By setting hispec = TRUE, you can get the output in list format with a smaller memory.
}
\examples{

imagedim1=c(10,10,10)

B1 = rbfunc(imagedim=imagedim1, seppix=4, hispec=TRUE)
B2 = rbfunc(imagedim=imagedim1, seppix=4, hispec=FALSE)

}
