% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/manifesto.R
\name{mp_availability}
\alias{mp_availability}
\title{Availability information for election programmes}
\usage{
mp_availability(ids, apikey = NULL, cache = TRUE)
}
\arguments{
\item{ids}{Information on which documents to get. This can either be a
    list of partys (as ids) and dates of elections as given to
    \code{\link{mp_metadata}} or a \code{ManifestoMetadata} object
    (\code{data.frame}) as returned by \code{\link{mp_metadata}}.
Alternatively, ids can be a logical expression specifying a subset of
the Manifesto Project's main dataset. It will be evaluated within the
data.frame returned by \code{\link{mp_maindataset}} such that all its
variables and functions thereof can be used in the expression.}

\item{apikey}{API key to use. Defaults to \code{NULL}, resulting in using
the API key set via \code{\link{mp_setapikey}}.}

\item{cache}{Boolean flag indicating whether to use locally cached data if
available.}
}
\value{
an object of class \code{\link{ManifestoAvailability}}
        containing availability information. Accessing \code{$availability}
        on it gives a \code{data.frame} with detailed availability information
        per document
}
\description{
Availability information for election programmes
}
\examples{
\dontrun{
mp_availability(countryname == "New Zealand")

wanted <- data.frame(party=c(41320, 41320), date=c(200909, 200509))
mp_availability(wanted)
}
}

