# Copyright © 2016 RTE Réseau de transport d’électricité

#' Generate controls UI of a manipulateWidget gadget
#'
#' This function can be used if you want to create a custom UI for your gadget
#' but desire to use the controls generated by function \code{manipulateWidget}
#'
#' @param controlList List of input controls.
#'
#' @return
#'   A \code{shiny.tag.list} that can be used to construct a UI for a shiny
#'   gadget.
#'
#' @noRd
#'
mwControlsUI <- function(controlList) {
  if (length(controlList) == 0) return(NULL)

  ids <- names(controlList)

  controls <- mapply(
    function(f, id) {
      if(is.list(f)) {
        ctrls <- mwControlsUI(f)
        label <- attr(f, "params")$label
        if (is.null(label)) label <- id
        id <- gsub("[^a-zA-Z0-9]", "_", id)
        res <- tags$div(
          class="panel panel-default",
          tags$div(
            class="panel-heading collapsed",
            style = "cursor: pointer;",
            "data-toggle"="collapse",
            "data-target"=paste0("#panel-body-", id),
            tags$table(
              tags$tbody(
                tags$tr(
                  tags$td(class = "arrow"),
                  tags$td(label)
                )
              )
            )
          ),
          tags$div(
            class="panel-body collapse",
            id=paste0("panel-body-", id),
            ctrls
          )
        )

      } else {
        params <- attr(f, "params")
        params$inputId <- id
        params$width <- "100%"

        res <- f(params)
      }

      shiny::conditionalPanel(
        condition = sprintf("input.%s_visible", id),
        res
      )
    },
    f = controlList, id = ids,
    SIMPLIFY = FALSE, USE.NAMES = FALSE
  )

  vis_checkboxes <- lapply(ids, function(id) {
    id <- gsub("[^a-zA-Z0-9]", "_", id)
    shiny::checkboxInput(paste0(id, "_visible"), "", value = TRUE)
  })
  vis_checkboxes$style <- "display:none"

  controls <- append(controls, list(do.call(tags$div, vis_checkboxes)))

  do.call(tags$div, controls)
}

.controlsCol <- function(controls) {
  do.call(tags$div, controls)
}

.controlsRow <- function(controls) {
  controls$height <- "100px"
  do.call(shiny::fillRow, controls)
}
