% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_report.R
\name{report}
\alias{report}
\alias{data_source}
\alias{data_contrast}
\alias{data_evolution}
\alias{open_codebook}
\title{Set of data structure exploration functions for users}
\usage{
data_source(pkg, database = NULL, dataset = NULL)

data_contrast(pkg, database = NULL, dataset = NULL)

data_evolution(pkg, database, dataset, preparation_script = FALSE)

open_codebook(pkg, database, dataset)
}
\arguments{
\item{pkg}{character string of the many package to report data on.
Required input.}

\item{database}{vector of character strings of the many package to
report data on a specific database in a many package
If NULL, the function returns a summary of all databases in the many package
NULL by default for \code{data_source()} and \code{data_contrast()}.}

\item{dataset}{character string of the many package to
report data on a specific
dataset in a specific database of a many package
If NULL and database is specified, returns database level metadata.
NULL by default for \code{data_source()} and \code{data_contrast()}.}

\item{preparation_script}{Would you like to open the preparation script
for the dataset? By default false.}
}
\value{
A dataframe with the data sources

A list with the desired metadata
to compare various datasets in a many package.

Either the data comparison between raw and available data or
the preparation script detailing all the steps taken to prepare
raw data before making it available in one of the 'many' packages.

Opens a pdf version of the original codebook of the specified
dataset, if available.
}
\description{
The report family of functions allows users
to quickly get information about and compare several
aspects of  a package in the many packages universe,
and its' databases and datasets.
}
\details{
\code{data_source()} displays names of the database/datasets and
source material of data in a many package.

\code{data_contrast()} displays information about databases
and datasets contained in them.
Namely the number of unique ID's, the percentage of
missing data, the number of observations, the number of variables,
the minimum beginning date and the maximum ending date as well as
the most direct URL to the original dataset.

\code{data_evolution()} enables users to access the
differences between raw data and the data made available to them
in one of the 'many' packages.

\code{open_codebook()} opens the original codebook of the specified
dataset to allow users to look up the original coding rules.
Note that no original codebook might exist for certain datasets.
In the latter case, please refer to the
source URL provided with each dataset by running \code{manydata::data_contrast()}
as further information on coding rules available online.
}
\examples{
\donttest{
data_source(pkg = "manydata")
}
\donttest{
data_contrast(pkg = "manydata")
}
\donttest{
data_evolution(pkg = "manydata", database = "emperors",
dataset = "wikipedia")
#data_evolution(pkg = "manytrade", database = "agreements",
#dataset = "GPTAD")
}
}
