% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stats.R
\name{get_data_Stats}
\alias{get_data_Stats}
\title{A pipe friendly way to get summary stats for exploratory data analysis}
\usage{
get_data_Stats(x, func, exclude = NULL, na.rm = TRUE,
  na_action = NULL)
}
\arguments{
\item{x}{The data for which stats are required}

\item{func}{The nature of function to apply}

\item{exclude}{What kind of data should be excluded? Defaults to NULL. Currently only supports
removing non-numeric data i.e exclude="non_numeric"}

\item{na.rm}{Logical. Should NAs be removed. Defaults to TRUE.}

\item{na_action}{If na.rm is set to TRUE, this uses na_replace to replace missing values.
See ?na_replace for details.}
}
\value{
A data.frame object showing the requested stats
}
\description{
A pipe friendly way to get summary stats for exploratory data analysis
}
\details{
A convenient wrapper especially useful for get_mode
}
\examples{
get_data_Stats(airquality,mean,"non_numeric",na.rm = TRUE,na_action = "mean")
}
