% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_transform.R
\name{transform}
\alias{transform}
\alias{to_mode1}
\alias{to_mode2}
\alias{to_giant}
\alias{to_subgraph}
\alias{to_ties}
\alias{to_blocks}
\alias{to_matching}
\alias{to_mentoring}
\alias{to_eulerian}
\alias{to_anti}
\alias{to_no_isolates}
\alias{to_galois}
\title{Tools for transforming networks, graphs, and matrices}
\usage{
to_mode1(.data, similarity = c("count", "jaccard", "rand", "pearson", "yule"))

to_mode2(.data, similarity = c("count", "jaccard", "rand", "pearson", "yule"))

to_giant(.data)

to_subgraph(.data, ...)

to_ties(.data)

to_blocks(.data, membership, FUN = mean)

to_matching(.data, mark = "type")

to_mentoring(.data, elites = 0.1)

to_eulerian(.data)

to_anti(.data)

to_no_isolates(.data)

to_galois(.data)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{similarity}{Method for establishing ties,
currently "count" (default), "jaccard", or "rand".
"count" calculates the number of coinciding ties,
and can be interpreted as indicating the degree of opportunities
between nodes.
"jaccard" uses this count as the numerator in a proportion,
where the denominator consists of any cell where either node has a tie.
It can be interpreted as opportunity weighted by participation.
"rand", or the Simple Matching Coefficient,
is a proportion where the numerator consists of the count of cells where
both nodes are present or both are absent,
over all possible cells.
It can be interpreted as the (weighted) degree of behavioral mirroring
between two nodes.
"pearson" (Pearson's coefficient) and "yule" (Yule's Q)
produce correlations for valued and binary data, respectively.
Note that Yule's Q has a straightforward interpretation related to the odds ratio.}

\item{...}{Arguments passed on to dplyr::filter}

\item{membership}{A vector of partition memberships.}

\item{FUN}{A function for summarising block content.
By default \code{mean}.
Other recommended options include \code{median}, \code{sum},
\code{min} or \code{max}.}

\item{mark}{A logical vector marking two types or modes.
By default "type".}

\item{elites}{The proportion of nodes to be selected as mentors.
By default this is set at 0.1.
This means that the top 10\% of nodes in terms of degree,
or those equal to the highest rank degree in the network,
whichever is the higher, will be used to select the mentors.

Note that if nodes are equidistant from two mentors,
they will choose one at random.
If a node is without a path to a mentor,
for example because they are an isolate,
a tie to themselves (a loop) will be created instead.
Note that this is a different default behaviour than that
described in Valente and Davis (1999).}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions offer tools for transforming migraph-consistent objects
(matrices, igraph, tidygraph, or network objects).
Transforming means that the returned object may have different dimensions
than the original object.

Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrrr}{
    \tab data.frame \tab igraph \tab list \tab matrix \tab network \tab tbl_graph \cr
   to_anti \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_blocks \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_eulerian \tab 0 \tab 1 \tab 0 \tab 0 \tab 0 \tab 1 \cr
   to_giant \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_matching \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_mode1 \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_mode2 \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_no_isolates \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_subgraph \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
   to_ties \tab 1 \tab 1 \tab 0 \tab 1 \tab 1 \tab 1 \cr
}
}
\section{Functions}{
\itemize{
\item \code{to_mode1()}: Results in a weighted one-mode object
that retains the row nodes from a two-mode object,
and weights the ties between them on the basis of
their joint ties to nodes in the second mode (columns)

\item \code{to_mode2()}: Results in a weighted one-mode object
that retains the column nodes from a two-mode object,
and weights the ties between them on the basis of
their joint ties to nodes in the first mode (rows).

\item \code{to_giant()}: Returns an object that includes only the main component
without any smaller components or isolates

\item \code{to_subgraph()}: Returns a network subgraph filtered
on the basis of some node-related logical statement.

\item \code{to_ties()}: Returns a matrix (named if possible)
where the edges are the nodes

\item \code{to_blocks()}: Returns a reduced graph from a given
partition membership vector.
Reduced graphs provide summary representations of network structures
by collapsing groups of connected nodes into single nodes
while preserving the topology of the original structures.

\item \code{to_matching()}: Returns a network with only
matching ties

\item \code{to_mentoring()}: Returns a network where each node is
connected only to their closest mentor

\item \code{to_eulerian()}: Returns a network with only
the Eulerian path

\item \code{to_anti()}: Returns the complement of a network
where only ties \emph{not} present in the original network
are included in the new network.

\item \code{to_no_isolates()}: Removes all nodes without ties

\item \code{to_galois()}: Galois derivations

}}
\section{to_matching}{

\code{to_matching()} uses \code{{igraph}}'s \code{max_bipartite_match()}
to return a network in which each node is only tied to
one of its previous ties.
The number of these ties left is its \emph{cardinality},
and the algorithm seeks to maximise this such that,
where possible, each node will be associated with just one
node in the other mode or some other mark.
The algorithm used is the push-relabel algorithm
with greedy initialization and a global relabelling
after every \eqn{\frac{n}{2}} steps,
where \eqn{n} is the number of nodes in the network.
}

\examples{
to_mode1(ison_southern_women)
to_mode2(ison_southern_women)
#autographr(to_mode1(ison_southern_women))
#autographr(to_mode2(ison_southern_women))
to_ties(ison_adolescents)
#autographr(to_ties(ison_adolescents))
to_matching(ison_southern_women)
#autographr(to_matching(ison_southern_women))
autographr(to_mentoring(ison_adolescents))
  to_eulerian(delete_nodes(ison_konigsberg, "Lomse"))
  #autographr(to_eulerian(delete_nodes(ison_konigsberg, "Lomse")))
to_anti(ison_southern_women)
#autographr(to_anti(ison_southern_women))
ison_adolescents \%>\%
  activate(edges) \%>\%
  mutate(wave = sample(1995:1998, 10, replace = TRUE)) \%>\%
  to_waves(attribute = "wave") \%>\%
  to_no_isolates()
}
\references{
Goldberg, A V; Tarjan, R E (1986).
"A new approach to the maximum flow problem".
\emph{Proceedings of the eighteenth annual ACM symposium on Theory of computing – STOC '86}. p. 136.
\doi{10.1145/12130.12144}

Valente, Thomas, and Rebecca Davis. 1999.
"Accelerating the Diffusion of Innovations Using Opinion Leaders",
\emph{Annals of the American Academy of Political and Social Science} 566: 56-67.
}
\seealso{
Other manipulations: 
\code{\link{add}},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{tidy}}
}
\concept{manipulations}
