% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_monastery}
\alias{ison_monastery}
\alias{ison_monastery_like}
\alias{ison_monastery_esteem}
\alias{ison_monastery_influence}
\alias{ison_monastery_praise}
\title{Three one-mode signed, weighted networks and a three-wave longitudinal network of monks (Sampson 1969)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A longitudinal, labelled, weighted, directed network with 18 nodes and 168 arcs
#> # A tibble: 18 x 3
#>   name        groups        left
#>   <chr>       <chr>        <dbl>
#> 1 Romuald     Interstitial     3
#> 2 Bonaventure Loyal            4
#> 3 Ambrose     Loyal            4
#> 4 Berthold    Loyal            4
#> 5 Peter       Loyal            3
#> 6 Louis       Loyal            4
#> # i 12 more rows
#> # A tibble: 168 x 4
#>    from    to weight  wave
#>   <int> <int>  <dbl> <dbl>
#> 1     1     5      3     1
#> 2     1     7      1     1
#> 3     1    11      2     1
#> 4     2     5      3     1
#> 5     2     6      2     1
#> 6     2    15      1     1
#> # i 162 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, signed, directed network with 18 nodes and 112 arcs
#> # A tibble: 18 x 3
#>   name        groups        left
#>   <chr>       <chr>        <dbl>
#> 1 Romuald     Interstitial     3
#> 2 Bonaventure Loyal            4
#> 3 Ambrose     Loyal            4
#> 4 Berthold    Loyal            4
#> 5 Peter       Loyal            3
#> 6 Louis       Loyal            4
#> # i 12 more rows
#> # A tibble: 112 x 3
#>    from    to  sign
#>   <int> <int> <dbl>
#> 1     2     3     1
#> 2     2     5     3
#> 3     2     6     2
#> 4     2    16    -1
#> 5     2    17    -3
#> 6     2    18    -2
#> # i 106 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, signed, directed network with 18 nodes and 103 arcs
#> # A tibble: 18 x 3
#>   name        groups        left
#>   <chr>       <chr>        <dbl>
#> 1 Romuald     Interstitial     3
#> 2 Bonaventure Loyal            4
#> 3 Ambrose     Loyal            4
#> 4 Berthold    Loyal            4
#> 5 Peter       Loyal            3
#> 6 Louis       Loyal            4
#> # i 12 more rows
#> # A tibble: 103 x 3
#>    from    to  sign
#>   <int> <int> <dbl>
#> 1     2     5     3
#> 2     2     6     2
#> 3     2    10     1
#> 4     2    16    -1
#> 5     2    17    -3
#> 6     2    18    -2
#> # i 97 more rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, signed, directed network with 18 nodes and 80 arcs
#> # A tibble: 18 x 3
#>   name        groups        left
#>   <chr>       <chr>        <dbl>
#> 1 Romuald     Interstitial     3
#> 2 Bonaventure Loyal            4
#> 3 Ambrose     Loyal            4
#> 4 Berthold    Loyal            4
#> 5 Peter       Loyal            3
#> 6 Louis       Loyal            4
#> # i 12 more rows
#> # A tibble: 80 x 3
#>    from    to  sign
#>   <int> <int> <dbl>
#> 1     4     3     1
#> 2     4     5     3
#> 3     4     6     2
#> 4     4    13    -3
#> 5     4    15    -1
#> 6     4    17    -2
#> # i 74 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(ison_monastery_like)

data(ison_monastery_esteem)

data(ison_monastery_influence)

data(ison_monastery_praise)
}
\description{
The data were collected for an ethnographic study of community structure in a New England monastery.
Various sociometric data was collected of the novices attending the minor seminary of 'Cloisterville'
preparing to join the monastic order:
\itemize{
\item \code{ison_monastery_like} records whom novices said they liked most at three time points/waves
\item \code{ison_monastery_esteem} records whom novices said they held in esteem (sign > 0) and disesteem (sign < 0)
\item \code{ison_monastery_praise} records whom novices said they praised (sign > 0) and blamed (sign < 0)
\item \code{ison_monastery_influence} records whom novices said were a positive influence (sign > 0) and negative influence (sign < 0)
}

All networks are weighted.
Novices' first choices are weighted 3, the second 2, and third choices 1.
Some subjects offered tied ranks for their top four choices.

In addition to node names,
a 'groups' variable records the four groups that Sampson observed during his time there:
\itemize{
\item The \emph{Loyal} Opposition consists of novices who entered the monastery first and defended existing practices
\item The \emph{Young Turks} arrived later during a period of change and questioned practices in the monastery
\item The \emph{Interstitial} did not take sides in the debate
\item The \emph{Outcasts} were novices that were not accepted in the group
}

Information about senior monks was not included.
While \code{ison_monastery_like} is observed over three waves,
the rest of the data was recorded retrospectively from the end of the study,
after the network fragmented.
The waves in which the novitiates were expelled (1), voluntarily departed (2 and 3),
or remained (4) are given in the nodal attribute "left".
}
\references{
Sampson, Samuel F. 1969. \emph{Crisis in a cloister}.
Unpublished doctoral dissertation, Cornell University.

Breiger R., Boorman S. and Arabie P. 1975.
"An algorithm for clustering relational data with applications to social network analysis and comparison with multidimensional scaling".
\emph{Journal of Mathematical Psychology}, 12: 328-383.
}
\keyword{datasets}
