% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformat.R
\name{to_levels}
\alias{to_levels}
\alias{to_onemode}
\alias{to_twomode}
\alias{to_multilevel}
\title{Modifying network levels}
\usage{
to_onemode(.data)

to_twomode(.data, mark)

to_multilevel(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{mark}{A logical vector marking two types or modes.
By default "type".}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions reformat the levels in manynet-consistent network data.
\itemize{
\item \code{to_onemode()} reformats two-mode network data into one-mode network data by simply removing the nodeset 'type' information.
Note that this is not the same as \code{to_mode1()} or \code{to_mode2()}.
\item \code{to_twomode()} reformats one-mode network data into two-mode network data, using a mark to distinguish the two sets of nodes.
\item \code{to_multilevel()} reformats two-mode network data into multimodal network data, which allows for more levels and ties within modes.
}

If the format condition is not met,
for example \code{to_onemode()} is used on a network that is already one-mode,
the network data is returned unaltered.
No warning is given so that these functions can be used to ensure conformance.

Unlike the \verb{as_*()} group of functions,
these functions always return the same class as they are given,
only transforming these objects' properties.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrr}{
    \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_multilevel \tab 1 \tab 1 \tab 0 \tab 1 \cr
   to_onemode \tab 1 \tab 1 \tab 0 \tab 1 \cr
   to_twomode \tab 1 \tab 0 \tab 1 \tab 1 \cr
}
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{as}()},
\code{\link{correlation}},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_paths}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
