% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_is.R
\name{is_format}
\alias{is_format}
\alias{is_twomode}
\alias{is_weighted}
\alias{is_directed}
\alias{is_labelled}
\alias{is_signed}
\alias{is_complex}
\alias{is_multiplex}
\alias{is_uniplex}
\alias{is_attributed}
\title{Marking networks formats}
\usage{
is_twomode(.data)

is_weighted(.data)

is_directed(.data)

is_labelled(.data)

is_signed(.data)

is_complex(.data)

is_multiplex(.data)

is_uniplex(.data)

is_attributed(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\description{
These functions implement logical tests for various network properties.
All \verb{is_*()} functions return a logical scalar (TRUE or FALSE).
\itemize{
\item \code{is_twomode()} marks networks TRUE if they contain two sets of nodes.
\item \code{is_weighted()} marks networks TRUE if they contain tie weights.
\item \code{is_directed()} marks networks TRUE if the ties specify which node
is the sender and which the receiver.
\item \code{is_labelled()} marks networks TRUE if there is a 'names' attribute
for the nodes.
\item \code{is_attributed()} marks networks TRUE if there are other nodal attributes
than 'names' or 'type'.
\item \code{is_signed()} marks networks TRUE if the ties can be either positive
or negative.
\item \code{is_complex()} marks networks TRUE if any ties are loops,
with the sender and receiver being the same node.
\item \code{is_multiplex()} marks networks TRUE if it contains multiple types
of ties, such that there can be multiple ties between the same
sender and receiver.
\item \code{is_uniplex()} marks networks TRUE if it is neither complex nor multiplex.
}
}
\examples{
is_twomode(create_filled(c(2,2)))
is_weighted(create_tree(3))
is_directed(create_tree(2))
is_directed(create_tree(2, directed = TRUE))
is_labelled(create_empty(3))
is_signed(create_lattice(3))
is_complex(create_lattice(4))
is_multiplex(create_filled(c(3,3)))
is_uniplex(create_star(3))
is_attributed(ison_algebra)
}
\seealso{
Other marking: 
\code{\link{features}},
\code{\link{is}()}
}
\concept{marking}
