% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_judo_moves}
\alias{ison_judo_moves}
\title{One-mode judo moves network (Bastazini 2025)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Judo attack combinations --------------------------------------------------
#> # A labelled, complex, directed network of 33 attacks and 81 sequence arcs
#> 
#> -- Nodes
#> # A tibble: 33 x 1
#>   name           
#>   <chr>          
#> 1 Seoi.nage      
#> 2 Seoi.otoshi    
#> 3 O.uchi.gari    
#> 4 Ko.uchi.gari   
#> 5 Ippon.seoi.nage
#> 6 Osoto.gari     
#> # i 27 more rows
#> 
#> -- Ties
#> # A tibble: 81 x 2
#>    from    to
#>   <int> <int>
#> 1     1     2
#> 2     1     3
#> 3     1     4
#> 4     3     4
#> 5     3     6
#> 6     3     7
#> # i 75 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_judo_moves)
}
\description{
Judo is a martial art with a long history and many different techniques.
It involves a dynamic 'chess match' of throws, holds, locks,
submission techniques, and other maneuvers.
The techniques are often combined in sequences to create fluid and
effective combinations to score points or achieve victory.
As the author of this network describes,
"While individual techniques (called waza) are foundational,
the real artistry lies in how they are chained together --
through renraku-waza (combination techniques) and
renzoku-waza (continuous combination techniques)"
This network describes the relationships between 33 individual judo moves,
as recognised by the Kodokan (the official international governing body of judo),
where an arc indicates that one move can be followed by another.
}
\references{
Bastazini, Vinicius. 2025.
"The Dynamics of the “Gentle Way”: Exploring Judo Attack Combinations as Networks in R",
https://geekcologist.wordpress.com/2025/05/27/the-dynamics-of-the-gentle-way-exploring-judo-attack-combinations-as-networks-in-r/

Kashiwazaki, Katsuhiko, and Hidetoshi Nakanishi. 1995.
\emph{Attacking Judo: A Guide to Combinations and Counters}.
Ippon Books.

Kawaishi, Mikinosuke. 1963.
\emph{Standing judo: The combinations and counter-attacks}.
Budoworks.

van Haesendonck, F.M. 1968.
\emph{Judo: Ecyclopédie par l’Image}.
Éditions Erasme: Anvers-Bruxelles.
}
\keyword{datasets}
