% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_can_box.R
\name{esp_get_can_box}
\alias{esp_get_can_box}
\alias{esp_get_can_provinces}
\title{Get complementary lines when plotting Canary Islands.}
\usage{
esp_get_can_box(style = "right", moveCAN = TRUE, epsg = "4258")

esp_get_can_provinces(moveCAN = TRUE, epsg = "4258")
}
\arguments{
\item{style}{Style of line around Canary Islands. Four options available:
\code{'left', 'right', 'box'} or \code{'poly'}.}

\item{moveCAN, epsg}{See \link{esp_get_nuts}}
}
\value{
A \code{LINESTRING} or \code{POLYGON} object if
\code{style = 'poly'}.

\code{esp_get_can_provinces} returns a \code{LINESTRING} object.
}
\description{
When plotting Spain, it is usual to represent the Canary
Islands as an inset (see \code{moveCAN} on \link{esp_get_nuts}). These
functions provides complementary borders when Canary Islands are displaces.

\code{esp_get_can_box} is used to draw lines around the displaced
Canary Islands.

\code{esp_get_can_provinces} is used to draw a separator
line between the two provinces of the Canary Islands.
}
\examples{
library(sf)

Provs <-  esp_get_prov()
Box <- esp_get_can_box()
Line <- esp_get_can_provinces()


plot(st_geometry(Provs), col = hcl.colors(4, palette = "Grays"))
plot(Box, add = TRUE)
plot(Line, add = TRUE)


# Displacing Canary

Provs_D <-  esp_get_prov(moveCAN = c(15, 0))
Box_D <- esp_get_can_box(style = "left", moveCAN = c(15, 0))
Line_D <- esp_get_can_provinces(moveCAN = c(15, 0))



plot(st_geometry(Provs_D), col = hcl.colors(4, palette = "Grays"))
plot(Box_D, add = TRUE)
plot(Line_D, add = TRUE)

# Example with poly option

library(giscoR)

Countries <-
  gisco_get_countries(res = "20",
                      epsg = "4326",
                      region = c("Europe", "Africa"))
CANbox <-
  esp_get_can_box(style = "poly",
                  epsg = "4326",
                  moveCAN = c(12.5, 0))
CCAA <- esp_get_ccaa(res = "20",
                     epsg = "4326",
                     moveCAN = c(12.5, 0))


plot_sf(CCAA, axes = TRUE)
plot(st_geometry(Countries), col = "grey80", add = TRUE)
plot(st_geometry(CANbox),
     border = "black",
     col = "white",
     add = TRUE)
plot(st_geometry(CCAA), add = TRUE, col = "beige")
box()
}
\seealso{
\link{esp_get_nuts}, \link{esp_get_ccaa}.
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
