% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{esp_tiles_providers}
\alias{esp_tiles_providers}
\title{List with information of Public WMS and WMTS of Spain}
\format{
A named list of the providers available with the following structure:
\itemize{
\item Each item of the list is named with the provider alias.
\item Each element of the list contains two nested named lists:
\itemize{
\item \code{static} with the parameters to get static tiles plus an additional item
named \code{attribution}.
\item \code{leaflet} with additional parameters to be passed onto
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}}.
}
}
}
\source{
\url{https://dieghernan.github.io/leaflet-providersESP/} leaflet plugin,
\strong{v1.3.2}.
}
\description{
A named list of length 98 containing
the parameters of the url information of different public WMS and WMTS
providers of Spain.

Implementation of javascript plugin
\href{https://dieghernan.github.io/leaflet-providersESP/}{leaflet-providersESP}
\strong{v1.3.2}.
}
\details{
Providers available to be passed to \code{type} on \code{\link[=esp_getTiles]{esp_getTiles()}} are:
\itemize{
\item \code{"IDErioja"}
\item \code{"IGNBase"}
\item \code{"IGNBase.Todo"}
\item \code{"IGNBase.Gris"}
\item \code{"IGNBase.TodoNoFondo"}
\item \code{"IGNBase.Orto"}
\item \code{"MDT"}
\item \code{"MDT.Elevaciones"}
\item \code{"MDT.Relieve"}
\item \code{"MDT.CurvasNivel"}
\item \code{"MDT.SpotElevation"}
\item \code{"PNOA"}
\item \code{"PNOA.MaximaActualidad"}
\item \code{"PNOA.Mosaico"}
\item \code{"OcupacionSuelo"}
\item \code{"OcupacionSuelo.Ocupacion"}
\item \code{"OcupacionSuelo.Usos"}
\item \code{"LiDAR"}
\item \code{"MTN"}
\item \code{"Geofisica"}
\item \code{"Geofisica.Terremotos10dias"}
\item \code{"Geofisica.Terremotos30dias"}
\item \code{"Geofisica.Terremotos365dias"}
\item \code{"Geofisica.ObservedEvents"}
\item \code{"Geofisica.HazardArea"}
\item \code{"VigilanciaVolcanica"}
\item \code{"VigilanciaVolcanica.ErupcionesHistoricas"}
\item \code{"CaminoDeSantiago"}
\item \code{"CaminoDeSantiago.CaminoFrances"}
\item \code{"CaminoDeSantiago.CaminosFrancia"}
\item \code{"CaminoDeSantiago.CaminosGalicia"}
\item \code{"CaminoDeSantiago.CaminosDelNorte"}
\item \code{"CaminoDeSantiago.CaminosAndaluces"}
\item \code{"CaminoDeSantiago.CaminosCentro"}
\item \code{"CaminoDeSantiago.CaminosEste"}
\item \code{"CaminoDeSantiago.CaminosCatalanes"}
\item \code{"CaminoDeSantiago.CaminosSureste"}
\item \code{"CaminoDeSantiago.CaminosInsulares"}
\item \code{"CaminoDeSantiago.CaminosPortugueses"}
\item \code{"Catastro"}
\item \code{"Catastro.Catastro"}
\item \code{"Catastro.Parcela"}
\item \code{"Catastro.CadastralParcel"}
\item \code{"Catastro.CadastralZoning"}
\item \code{"Catastro.Address"}
\item \code{"Catastro.Building"}
\item \code{"Catastro.BuildingPart"}
\item \code{"Catastro.AdministrativeBoundary"}
\item \code{"Catastro.AdministrativeUnit"}
\item \code{"RedTransporte"}
\item \code{"RedTransporte.Carreteras"}
\item \code{"RedTransporte.Ferroviario"}
\item \code{"RedTransporte.Aerodromo"}
\item \code{"RedTransporte.AreaServicio"}
\item \code{"RedTransporte.EstacionesFerroviario"}
\item \code{"RedTransporte.Puertos"}
\item \code{"Cartociudad"}
\item \code{"Cartociudad.CodigosPostales"}
\item \code{"Cartociudad.Direcciones"}
\item \code{"NombresGeograficos"}
\item \code{"UnidadesAdm"}
\item \code{"UnidadesAdm.Limites"}
\item \code{"UnidadesAdm.Unidades"}
\item \code{"Hidrografia"}
\item \code{"Hidrografia.MasaAgua"}
\item \code{"Hidrografia.Cuencas"}
\item \code{"Hidrografia.Subcuencas"}
\item \code{"Hidrografia.POI"}
\item \code{"Hidrografia.ManMade"}
\item \code{"Hidrografia.LineaCosta"}
\item \code{"Hidrografia.Rios"}
\item \code{"Hidrografia.Humedales"}
\item \code{"Militar"}
\item \code{"Militar.CEGET1M"}
\item \code{"Militar.CEGETM7814"}
\item \code{"Militar.CEGETM7815"}
\item \code{"Militar.CEGETM682"}
\item \code{"Militar.CECAF1M"}
\item \code{"ADIF"}
\item \code{"ADIF.Vias"}
\item \code{"ADIF.Nodos"}
\item \code{"ADIF.Estaciones"}
\item \code{"LimitesMaritimos"}
\item \code{"LimitesMaritimos.LimitesMaritimos"}
\item \code{"LimitesMaritimos.LineasBase"}
\item \code{"Copernicus"}
\item \code{"Copernicus.Forest"}
\item \code{"Copernicus.ForestLeaf"}
\item \code{"Copernicus.WaterWet"}
\item \code{"Copernicus.SoilSeal"}
\item \code{"Copernicus.GrassLand"}
\item \code{"Copernicus.RiparianGreen"}
\item \code{"Copernicus.RiparianLandCover"}
\item \code{"Copernicus.Natura2k"}
\item \code{"Copernicus.UrbanAtlas"}
\item \code{"ParquesNaturales"}
\item \code{"ParquesNaturales.Limites"}
\item \code{"ParquesNaturales.ZonasPerifericas"}
}
}
\examples{
data("esp_tiles_providers")
# Get a single provider

single <- esp_tiles_providers[["IGNBase.Todo"]]
single$static

single$leaflet

}
\seealso{
Other datasets: 
\code{\link{esp_codelist}},
\code{\link{esp_munic.sf}},
\code{\link{esp_nuts.sf}},
\code{\link{pobmun19}}

Other imagery utilities: 
\code{\link{addProviderEspTiles}()},
\code{\link{esp_getTiles}()},
\code{\link{esp_make_provider}()}
}
\concept{datasets}
\concept{imagery utilities}
