% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mapbayr_plot}
\alias{mapbayr_plot}
\title{Make mapbayr plot}
\usage{
mapbayr_plot(
  aug_tab,
  obs_tab = NULL,
  PREDICTION = c("IPRED", "PRED"),
  MODEL_color = NULL
)
}
\arguments{
\item{aug_tab}{a table of predictions, generated by \code{augment(x)} and available at \code{x$aug_tab}}

\item{obs_tab}{a table of observations}

\item{PREDICTION}{plot either "IPRED", "PRED" or both.}

\item{MODEL_color}{a vector of strings interpretable as colors, with names that correspond to a value in \code{aug_tab$MODEL}}
}
\value{
a \code{ggplot} object
}
\description{
Make mapbayr plot
}
\examples{
aug <- data.frame(
  ID = 1, name = factor("DV"), cmt = 2, time = rep(c(0,8,16,24), each = 2),
  type = rep(c("PRED", "IPRED"), 4), value = c(0,0, 1, 2, 4, 8, 2, 4)
  )

obs <- data.frame(
  ID = 1, time = c(6, 20), evid = 0,
  mdv = c(0,1), DV = c(0.5, 5), cmt = 2
  )

mapbayr_plot(aug, obs)
mapbayr_plot(aug, obs, PREDICTION = "IPRED")

aug2 <- dplyr::bind_rows(
  FOO = aug,
  BAZ = dplyr::mutate(aug, value = value * 2),
  BAR = dplyr::mutate(aug, value = value * 3),
  .id = "MODEL"
  )

mapbayr_plot(aug2, obs)
mapbayr_plot(aug2, obs, PREDICTION = "IPRED")
mapbayr_plot(aug2, obs, PREDICTION = "IPRED", MODEL_color = c(FOO = "black"))


}
