% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tippecanoe.R
\name{tippecanoe}
\alias{tippecanoe}
\title{Generate an .mbtiles file with tippecanoe}
\usage{
tippecanoe(
  input,
  output,
  layer_name = NULL,
  min_zoom = NULL,
  max_zoom = NULL,
  drop_rate = NULL,
  overwrite = TRUE,
  other_options = NULL,
  keep_geojson = FALSE
)
}
\arguments{
\item{input}{The dataset from which to generate vector tiles.  Can be an sf object or GeoJSON file on disk.}

\item{output}{The name of the output .mbtiles file (with .mbtiles extension).  Will be saved in the current working directory.}

\item{layer_name}{The name of the layer in the output .mbtiles file. If NULL, will either be a random string (if input is an sf object) or the name of the input GeoJSON file (if input is a file path).}

\item{min_zoom}{The minimum zoom level for which to compute tiles.}

\item{max_zoom}{The maximum zoom level for which to compute tiles.  If both min_zoom and max_zoom are blank, tippecanoe will guess the best zoom levels for your data.}

\item{drop_rate}{The rate at which tippecanoe will drop features as you zoom out. If NULL, tippecanoe will drop features as needed in the densest tiles to stay within Mapbox's limits.}

\item{overwrite}{If TRUE, an existing .mbtiles file with the same name will be overwritten.}

\item{other_options}{A character string of other options to be passed to the tippecanoe program.}

\item{keep_geojson}{Whether nor not to keep the temporary CSV or GeoJSON file used to generate the tiles.  Defaults to \code{FALSE}.}
}
\description{
Generate an .mbtiles file with tippecanoe
}
\examples{
\dontrun{

# Workflow: create a dynamic tileset for dot-density mapping
library(tidycensus)
library(sf)
library(mapboxapi)

# Get population data for Census tracts in Vermont
vt_population <- get_decennial(
  geography = "tract",
  variables = "P001001",
  state = "Vermont",
  year = 2010,
  geometry = TRUE
)

# Convert to representative dots - 1 per person
vt_dots <- st_sample(
  vt_population,
  size = vt_population$value
)

# Use tippecanoe to create dynamic tiles
tippecanoe(
  input = vt_dots,
  output = "vt_population.mbtiles",
  layer_name = "vermont_population",
  max_zoom = 18,
  drop_rate = 1.5
)

# Upload to your Mapbox account for visualization
# A Mapbox secret access token must be set with mb_access_token()
# to upload data to your account
upload_tiles(
  input = "vt_population.mbtiles",
  username = "kwalkertcu",
  tileset_id = "vt_population_dots",
  multipart = TRUE
)

}

}
