% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_pointcloud.R
\name{add_pointcloud}
\alias{add_pointcloud}
\title{Add Pointcloud}
\usage{
add_pointcloud(map, data = get_map_data(map), lon = NULL, lat = NULL,
  elevation, polyline = NULL, radius = NULL, fill_colour = NULL,
  fill_opacity = NULL, stroke_width = NULL, light_settings = list(),
  layer_id, digits = 6, palette = viridisLite::viridis)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer}

\item{lon}{column containing longitude values}

\item{lat}{column containing latitude values}

\item{elevation}{column containing the elevation values}

\item{polyline}{column of \code{data} containing the polylines}

\item{radius}{in metres}

\item{fill_colour}{column of \code{data} or hex colour for the fill colour}

\item{fill_opacity}{value between 1 and 255. Either a string specifying the
column of \code{data} containing the fill opacity of each shape, or a value
between 1 and 255 to be applied to all the shapes}

\item{stroke_width}{width of the stroke}

\item{light_settings}{list of light setting parameters. See \link{light_settings}}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{palette}{a function which generates hex colours}
}
\description{
The Pointcloud Layer takes in coordinate points and renders them as circles
with a certain radius.
}
\examples{
\donttest{
## You need a valid access token from Mapbox
key <- 'abc'

df <- capitals
df$z <- sample(10000:10000000, size = nrow(df))

mapdeck(token = key, style = 'mapbox://styles/mapbox/dark-v9') \%>\%
add_pointcloud(
  data = df
  , lon = 'lon'
  , lat = 'lat'
  , elevation = 'z'
  , layer_id = 'point'
  , fill_colour = "country"
)
}

}
