% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.mapfuser.R
\name{predict.mapfuser}
\alias{predict.mapfuser}
\title{Predict centiMorgan positions from fitted gam models on the mapfuser object}
\usage{
\method{predict}{mapfuser}(object, to_predict, ...)
}
\arguments{
\item{object}{A mapfuser object with fitted gam models}

\item{to_predict}{A csv file with columns marker, chromosome ID and position in mega base pairs.}

\item{...}{ingored in function call}
}
\value{
A data frame with columns "Marker", "Chr", "Position", and "Position_physical"
}
\description{
Takes a fitted thin plate regression spline produced by gam() and produces predictions of centi Morgan positions using known physical genome positions and fitted gam models.
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "Bur", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE, type = "delim")
ref_file <- list.files(fpath, pattern = "reference", full.names = TRUE)
MF.obj <- read_ref(MF.obj = MF.obj, ref_file = ref_file, sep = ",", header = TRUE, type = "delim")
MF.obj$config$chromosomes <- "1"
MF.obj <- genphys_fit(MF.obj, map = "Col-0_Bur-0.csv", type = "map")
fpath <- system.file("extdata", package="mapfuser")
prd <- read.table(paste0(fpath, "/BaySha_physical.csv"), sep = ",", header = TRUE)
MF.obj <- predict(MF.obj, prd)
}
\dontrun{
# Read a table with positions to interpolate and/or extrapolate
fpath <- system.file("extdata", package="mapfuser")
to_predict <- read.table(paste0(fpath, "/BaySha_physical.csv"), sep = ",", header = TRUE)
MF.obj <- predict(MF.obj, to_predict)
# Write to csv
write.table(MF.obj$predictions, file = "preds.csv", sep = ",", col.names = TRUE, row.names = FALSE)
}
}
\author{
Dennis van Muijen
}
