% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{add_legend}
\alias{add_legend}
\title{Add a legend to a Mapbox GL map}
\usage{
add_legend(
  map,
  legend_title,
  values,
  colors,
  type = c("continuous", "categorical"),
  circular_patches = FALSE,
  position = "top-left",
  sizes = NULL,
  add = FALSE,
  unique_id = NULL,
  width = NULL,
  layer_id = NULL,
  margin_top = NULL,
  margin_right = NULL,
  margin_bottom = NULL,
  margin_left = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} function.}

\item{legend_title}{The title of the legend.}

\item{values}{The values being represented on the map (either a vector of categories or a vector of stops).}

\item{colors}{The corresponding colors for the values (either a vector of colors, a single color, or an interpolate function).}

\item{type}{One of "continuous" or "categorical".}

\item{circular_patches}{Logical, whether to use circular patches in the legend (only for categorical legends).}

\item{position}{The position of the legend on the map (one of "top-left", "bottom-left", "top-right", "bottom-right").}

\item{sizes}{An optional numeric vector of sizes for the legend patches, or a single numeric value (only for categorical legends).}

\item{add}{Logical, whether to add this legend to existing legends (TRUE) or replace existing legends (FALSE). Default is FALSE.}

\item{unique_id}{Optional. A unique identifier for the legend. If not provided, a random ID will be generated.}

\item{width}{The width of the legend. Can be specified in pixels (e.g., "250px") or as "auto". Default is NULL, which uses the built-in default.}

\item{layer_id}{The ID of the layer that this legend is associated with. If provided, the legend will be shown/hidden when the layer visibility is toggled.}

\item{margin_top}{Custom top margin in pixels, allowing for fine control over legend positioning. Default is NULL (uses standard positioning).}

\item{margin_right}{Custom right margin in pixels. Default is NULL.}

\item{margin_bottom}{Custom bottom margin in pixels. Default is NULL.}

\item{margin_left}{Custom left margin in pixels. Default is NULL.}
}
\value{
The updated map object with the legend added.
}
\description{
Add a legend to a Mapbox GL map
}
