% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_fill_layer}
\alias{add_fill_layer}
\title{Add a fill layer to a map}
\usage{
add_fill_layer(
  map,
  id,
  source,
  source_layer = NULL,
  fill_antialias = TRUE,
  fill_color = NULL,
  fill_emissive_strength = NULL,
  fill_opacity = NULL,
  fill_outline_color = NULL,
  fill_pattern = NULL,
  fill_sort_key = NULL,
  fill_translate = NULL,
  fill_translate_anchor = "map",
  fill_z_offset = NULL,
  visibility = "visible",
  slot = NULL,
  min_zoom = NULL,
  max_zoom = NULL,
  popup = NULL,
  tooltip = NULL,
  hover_options = NULL,
  before_id = NULL,
  filter = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} functions.}

\item{id}{A unique ID for the layer.}

\item{source}{The ID of the source, alternatively an sf object (which will be converted to a GeoJSON source) or a named list that specifies \code{type} and \code{url} for a remote source.}

\item{source_layer}{The source layer (for vector sources).}

\item{fill_antialias}{Whether or not the fill should be antialiased.}

\item{fill_color}{The color of the filled part of this layer.}

\item{fill_emissive_strength}{Controls the intensity of light emitted on the source features.}

\item{fill_opacity}{The opacity of the entire fill layer.}

\item{fill_outline_color}{The outline color of the fill.}

\item{fill_pattern}{Name of image in sprite to use for drawing image fills.}

\item{fill_sort_key}{Sorts features in ascending order based on this value.}

\item{fill_translate}{The geometry's offset. Values are \code{c(x, y)} where negatives indicate left and up.}

\item{fill_translate_anchor}{Controls the frame of reference for \code{fill-translate}.}

\item{fill_z_offset}{Specifies an uniform elevation in meters.}

\item{visibility}{Whether this layer is displayed.}

\item{slot}{An optional slot for layer order.}

\item{min_zoom}{The minimum zoom level for the layer.}

\item{max_zoom}{The maximum zoom level for the layer.}

\item{popup}{A column name containing information to display in a popup on click.  Columns containing HTML will be parsed.}

\item{tooltip}{A column name containing information to display in a tooltip on hover. Columns containing HTML will be parsed.}

\item{hover_options}{A named list of options for highlighting features in the layer on hover.}

\item{before_id}{The name of the layer that this layer appears "before", allowing you to insert layers below other layers in your basemap (e.g. labels).}

\item{filter}{An optional filter expression to subset features in the layer.}
}
\value{
The modified map object with the new fill layer added.
}
\description{
Add a fill layer to a map
}
\examples{
\dontrun{
library(tidycensus)

fl_age <- get_acs(
    geography = "tract",
    variables = "B01002_001",
    state = "FL",
    year = 2022,
    geometry = TRUE
)

mapboxgl() |>
    fit_bounds(fl_age, animate = FALSE) |>
    add_fill_layer(
        id = "fl_tracts",
        source = fl_age,
        fill_color = interpolate(
            column = "estimate",
            values = c(20, 80),
            stops = c("lightblue", "darkblue"),
            na_color = "lightgrey"
        ),
        fill_opacity = 0.5
    )
}
}
