% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_soilproperties.R
\docType{data}
\name{soilproperties}
\alias{soilproperties}
\title{Calculate Zonal Soil Properties}
\format{
A tibble with a column for the SoilGrid layer, the depth and the model
output statistic as well as additional columns for all zonal statistics
specified via \code{stats_soil}
}
\description{
This indicator allows the extraction of zonal statistics for resource layers
previously downloaded from SoilGrids, thus in total supporting the calculation
of zonal statistics for 10 different soil properties at 6 different depths for
a total of 4 different model outputs (stat). Zonal statistics will be calculated
for all SoilGrid layers that have been previously made available vie \code{get_resources()}.
The required resource for this indicator is:
\itemize{
\item \link{soilgrids}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_soil}{Function to be applied to compute statistics for polygons either
single or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)


aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2022,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources("soilgrids",
    layers = c("clay", "silt"), depths = c("0-5cm", "5-15cm"), stats = "mean"
  ) \%>\%
  calc_indicators("soilproperties", stats_soil = c("mean", "median"), engine = "extract") \%>\%
  tidyr::unnest(soilproperties)

aoi
}
}
\keyword{indicator}
