% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecover_area_and_emissions.R
\docType{data}
\name{treecover_area_and_emissions}
\alias{treecover_area_and_emissions}
\title{Calculate treeloss statistics}
\format{
A tibble with a column for years, treecover (in ha), and emissions (in Mg CO2)
}
\description{
This functions allows to efficiently calculate the treecover and emissions
indicators in a single function call together. Since most of the pre-processing
operations for treecover and emissions are the same, it is more efficient
to calculate them in one run if users are actually interested in both statistics.
Otherwise users are advised to use the respective single indicator functions.
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
\item \link{gfw_emissions}.
}
}
\details{
The following arguments can be set:
\describe{
\item{min_size}{The minimum size of a forest patch to be considered as forest in ha.}
\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2016:2017,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources(
    resources = c("gfw_treecover", "gfw_lossyear", "gfw_emissions"),
    vers_treecover = "GFC-2021-v1.9", vers_lossyear = "GFC-2021-v1.9"
  ) \%>\%
  calc_indicators("treecover_area_and_emissions", min_size = 1, min_cover = 30) \%>\%
  tidyr::unnest(treecover_area_and_emissions)

aoi
}
}
\keyword{indicator}
