% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gsw.R
\name{global_surface_water_recurrence}
\alias{global_surface_water_recurrence}
\alias{get_global_surface_water_recurrence}
\title{Global Surface Water Recurrence}
\source{
\url{https://global-surface-water.appspot.com/}
}
\usage{
get_global_surface_water_recurrence(version = "v1_4_2021")
}
\arguments{
\item{version}{A character vector indicating the version of the GSW data set
to make available.}
}
\value{
A character of file paths.
}
\description{
The Global Surface Water dataset was developed by the European Commission's
Joint Research Centre in the framework of the Copernicus Programme. It maps
the location and temporal distribution of water surfaces at the global scale
over the past 3.8 decades and provides statistics on their extent and change.
It is provisioned as a global tiled raster resource available for all land
areas. The reported data represent aggregated observations between 1984 - 2021.
}
\details{
Water Recurrence is a measurement of the degree of variability in the
presence of water from year to year. It describes the frequency with which
water returned to a particular location from one year to another, and is
expressed as a percentage. The raster files have integer cell values between
\code{[0, 100]}, where 100 represents that water reoccurs predictably every
year, whereas lower values indicate that water only occurs episodically.
}
\references{
Pekel, JF., Cottam, A., Gorelick, N. et al. High-resolution
mapping of global surface water and its long-term changes. Nature 540,
418–422 (2016). https://doi.org/10.1038/nature20584
}
\keyword{resource}
