% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_structure_plot.R
\name{structure_plot}
\alias{structure_plot}
\title{STRUCTURE Barplot}
\usage{
structure_plot(
  admixture_df,
  type = "structure",
  cluster_cols = NULL,
  cluster_names = NULL,
  legend = "none",
  labels = "site",
  flip_axis = FALSE,
  ylabel = "Proportion",
  site_dividers = TRUE,
  divider_width = 1,
  site_order = NULL,
  site_labels_size = 2,
  site_labels_x = 0,
  site_labels_y = -0.025,
  site_ticks = TRUE,
  site_ticks_size = -0.01,
  facet_col = NULL,
  facet_row = NULL
)
}
\arguments{
\item{admixture_df}{data.frame or tibble containing admixture data (see examples).}

\item{type}{show a traditional STRUCTURE barplot ("structure")
or a facet barplot ("facet").}

\item{cluster_cols}{character vector of colours the same length as the number of clusters.
If \code{NULL}, a blue-green palette is used.}

\item{cluster_names}{character vector of names the same length as the number of clusters.
If \code{NULL}, the cluster column names are used.}

\item{legend}{add legend at position (\code{"none"}, \code{"top"}, \code{"right"}, \code{"bottom"} or \code{"left"}).
Default is to hide legend.}

\item{labels}{show labels at the site level or the
individual level ("site" or "individual").}

\item{flip_axis}{flip the axes so that the plot is vertical (TRUE or FALSE).
Default is FALSE (horizontal barplot).}

\item{ylabel}{string for y label.}

\item{site_dividers}{add dotted lines that divide sites (TRUE or FALSE).}

\item{divider_width}{width of site divider lines.}

\item{site_order}{character vector of site labels used to customise the order of sites.
If \code{NULL}, sites are ordered alphabetically.}

\item{site_labels_size}{numeric value for site label size.}

\item{site_labels_x}{numeric value for site label horizontal position.}

\item{site_labels_y}{numeric value for site label vertical position.}

\item{site_ticks}{show ticks when labels = "site".}

\item{site_ticks_size}{numeric value for site tick size.}

\item{facet_col}{number of columns to display for facet barplot.}

\item{facet_row}{number of rows to display for facet barplot.}
}
\value{
A ggplot object.
}
\description{
Plot a traditional STRUCTURE barplot or
a facet barplot from individual admixture proportions.
}
\examples{
# Admixture Format 1
file <- system.file("extdata", "admixture1.csv", package = "mapmixture")
admixture1 <- read.csv(file)

structure_plot(admixture1, type = "structure")
structure_plot(admixture1, type = "facet", facet_col = 5)
}
