% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baskin_robbins.R
\name{create_1D_mapper_object}
\alias{create_1D_mapper_object}
\title{Run 1D mapper}
\usage{
create_1D_mapper_object(
  data,
  dists,
  filtered_data,
  cover,
  clustering_method = "single",
  global_clustering = TRUE
)
}
\arguments{
\item{data}{A data frame.}

\item{dists}{A distance matrix for the data frame.}

\item{filtered_data}{The result of a function applied to the data frame; there should be one filter value per observation in the original data frame.}

\item{cover}{A 2D array of interval left and right endpoints; rows should be intervals and columns left and right endpoints (in that order).}

\item{clustering_method}{A string to pass to \link{hclust} to determine clustering method.}

\item{global_clustering}{Whether you want clustering to happen in a global (all level visible) or local (only current level set visible) context.}
}
\value{
A list of two data frames, one with node data containing bin membership,
data points per cluster, and cluster dispersion, and one with edge data
containing sources, targets, and weights representing overlap strength.
}
\description{
Run mapper using a one-dimensional filter, a cover of intervals, and a clustering algorithm.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x

num_bins = 10
percent_overlap = 25

cover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

create_1D_mapper_object(data, dist(data), projx, cover, "single")
}
