% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterer_farm.R
\name{hierarchical_clusterer}
\alias{hierarchical_clusterer}
\title{Create a little dude to perform hierarchical clustering in a semi-global context using the \link{hclust} package.}
\usage{
hierarchical_clusterer(method)
}
\arguments{
\item{method}{A string to pass to \link{hclust} to tell it what kind of clustering to do.}
}
\value{
A function that inputs a list of distance matrices and returns a list containing one vector per bin, whose element names are data point names and whose values are cluster labels (within each bin).
}
\description{
Create a little dude to perform hierarchical clustering in a semi-global context using the \link{hclust} package.
}
\details{
This clusterer determines cutting heights for bin dendrograms generated by \link{hclust} by first considering the tallest branches across all dendrograms; if all branch heights of a given dendrogram are below a threshold (10 percent of the global tallest), that dendrogram will be considered to describe a single cluster. Additionally, if the index of dispersion of the branch heights of a dendrogram are below 0.015, we will also consider it as describing a single cluster. If neither of these are true, then we will cut the dendrogram at its longest branch.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x

num_bins = 10
percent_overlap = 25

cover = create_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

create_1D_mapper_object(data, dist(data), projx, cover, hierarchical_clusterer("mcquitty"))
}
