% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_drop.R
\name{add_marker}
\alias{add_marker}
\title{Add a single marker to a map}
\usage{
add_marker(
  input.map,
  mrk,
  pos,
  rf.matrix,
  genoprob = NULL,
  phase.config = "best",
  tol = 0.001,
  extend.tail = NULL,
  r.test = NULL,
  verbose = TRUE
)
}
\arguments{
\item{input.map}{an object of class \code{mappoly.map}}

\item{mrk}{the name of the marker to be inserted}

\item{pos}{the name of the marker after which the new marker should be added.
One also can inform the numeric position (between markers) were the 
new marker should be added. To insert a marker at the beginning of a 
map, use \code{pos = 0}}

\item{rf.matrix}{an object of class \code{mappoly.rf.matrix} containing the recombination
fractions and the number of homologues sharing alleles between pairwise 
markers on \code{input.map}. It is important that \code{shared.alleles = TRUE}
in function \code{\link[mappoly]{rf_list_to_matrix}} when computing \code{rf.matrix}.}

\item{genoprob}{an object of class \code{mappoly.genoprob} containing the genotype probabilities
for all marker positions on \code{input.map}}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the maximum likelihood configuration}

\item{tol}{the desired accuracy (default = 10e-04)}

\item{extend.tail}{the length of the chain's tail that should
be used to calculate the likelihood of the map. If \code{NULL} (default), 
the function uses all markers positioned.}

\item{r.test}{for internal use only}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
A list of class \code{mappoly.map} with two elements: 

i) info:  a list containing information about the map, regardless of the linkage phase configuration:
\item{ploidy}{the ploidy level}
\item{n.mrk}{number of markers}
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{mrk.names}{the names of markers in the map}
\item{seq.dose.p1}{a vector containing the dosage in parent 1 for all markers in the map}
\item{seq.dose.p2}{a vector containing the dosage in parent 2 for all markers in the map}
\item{chrom}{a vector indicating the sequence (usually chromosome) each marker belongs 
                as informed in the input file. If not available, 
                \code{chrom = NULL}}
\item{genome.pos}{physical position (usually in megabase) of the markers into the sequence}
\item{seq.ref}{reference base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}                 
\item{seq.alt}{alternative base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}
\item{chisq.pval}{a vector containing p-values of the chi-squared test of Mendelian 
                  segregation for all markers in the map}                 
\item{data.name}{name of the dataset of class \code{mappoly.data}}
\item{ph.thres}{the LOD threshold used to define the linkage phase configurations to test}

ii) a list of maps with possible linkage phase configuration. Each map in the list is also a 
   list containing
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{seq.rf}{a vector of size (\code{n.mrk - 1}) containing a sequence of recombination 
              fraction between the adjacent markers in the map}
\item{seq.ph}{linkage phase configuration for all markers in both parents}
\item{loglike}{the hmm-based multipoint likelihood}
}
\description{
Creates a new map by adding a marker in a given position in a pre-built map.
}
\details{
\code{add_marker} splits the input map into two sub-maps to the left and the 
right of the given position. Using the genotype probabilities, it computes 
the log-likelihood of all possible linkage phases under a two-point threshold
inherited from function \code{\link[mappoly]{rf_list_to_matrix}}.
}
\examples{
\donttest{
sub.map <- get_submap(maps.hexafake[[1]], 1:20, reestimate.rf = FALSE)
plot(sub.map, mrk.names = TRUE)
s <- make_seq_mappoly(hexafake, sub.map$info$mrk.names)
tpt <- est_pairwise_rf(s)
rf.matrix <- rf_list_to_matrix(input.twopt = tpt,
                               thresh.LOD.ph = 3, 
                               thresh.LOD.rf = 3,
                               shared.alleles = TRUE)
###### Removing marker "M_1" (first) #######
mrk.to.remove <- "M_1"
input.map <- drop_marker(sub.map, mrk.to.remove)
plot(input.map, mrk.names = TRUE)
## Computing conditional probabilities using the resulting map
genoprob <- calc_genoprob(input.map)
res.add.M_1 <- add_marker(input.map = input.map,
                        mrk = "M_1",
                        pos = 0,
                        rf.matrix = rf.matrix,
                        genoprob = genoprob,
                        tol = 10e-4)  
 plot(res.add.M_1, mrk.names = TRUE)                       
 best.phase <- res.add.M_1$maps[[1]]$seq.ph
 names.id <- names(best.phase$P)
 plot_compare_haplotypes(ploidy = 6,
                         hom.allele.p1 = best.phase$P[names.id],
                         hom.allele.q1 = best.phase$Q[names.id],
                         hom.allele.p2 = sub.map$maps[[1]]$seq.ph$P[names.id],
                         hom.allele.q2 = sub.map$maps[[1]]$seq.ph$Q[names.id])
                         
###### Removing marker "M_10" (middle or last) #######
mrk.to.remove <- "M_10"
input.map <- drop_marker(sub.map, mrk.to.remove)
plot(input.map, mrk.names = TRUE)
# Computing conditional probabilities using the resulting map
genoprob <- calc_genoprob(input.map)
res.add.M_10 <- add_marker(input.map = input.map,
                        mrk = "M_10",
                        pos = "M_9",
                        rf.matrix = rf.matrix,
                        genoprob = genoprob,
                        tol = 10e-4)  
 plot(res.add.M_10, mrk.names = TRUE)                       
 best.phase <- res.add.M_10$maps[[1]]$seq.ph
 names.id <- names(best.phase$P)
 plot_compare_haplotypes(ploidy = 6,
                         hom.allele.p1 = best.phase$P[names.id],
                         hom.allele.q1 = best.phase$Q[names.id],
                         hom.allele.p2 = sub.map$maps[[1]]$seq.ph$P[names.id],
                         hom.allele.q2 = sub.map$maps[[1]]$seq.ph$Q[names.id]) 
}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
