% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_map_by_steps.R
\name{update_framework_map}
\alias{update_framework_map}
\title{Add markers that are informative in both parents using HMM approach and evaluating difference 
in LOD and gap size}
\usage{
update_framework_map(
  input.map.list,
  input.seq,
  twopt,
  thres.twopt = 10,
  init.LOD = 30,
  verbose = TRUE,
  method = "hmm",
  input.mds = NULL,
  max.rounds = 50,
  size.rem.cluster = 2,
  gap.threshold = 4
)
}
\arguments{
\item{input.map.list}{list containing three \code{mappoly.map} objects:1) map built with markers with segregation information from parent 1; 
2) map built with markers with segregation information from parent 2; 3) maps in 1 and 2 merged}

\item{input.seq}{object of class \code{mappoly.sequence} containing all markers for specific group}

\item{twopt}{object of class \code{mappoly.twopt}}

\item{thres.twopt}{the LOD threshold used to determine if the linkage phases compared via two-point 
analysis should be considered for the search space reduction (default = 5)}

\item{init.LOD}{the LOD threshold used to determine if the marker will be included or not after hmm analysis  (default = 30)}

\item{verbose}{If TRUE (default), current progress is shown; if FALSE, no output is produced}

\item{method}{indicates whether to use 'hmm' (Hidden Markov Models), 'ols' (Ordinary Least Squares) or 'wMDS_to_1D_pc' 
(weighted MDS followed by fitting a one dimensional principal curve) to re-estimate the recombination fractions after adding markers}

\item{input.mds}{An object of class \code{mappoly.map}}

\item{max.rounds}{integer defining number of times to try to fit the remaining markers in the sequence}

\item{size.rem.cluster}{threshold for number of markers that must contain in a segment after a gap is removed to keep this segment in the sequence}

\item{gap.threshold}{threshold for gap size}
}
\value{
object of class \code{mappoly.map2}
}
\description{
Add markers that are informative in both parents using HMM approach and evaluating difference 
in LOD and gap size
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu} with documentation and minor modifications by Cristiane Taniguti \email{chtaniguti@tamu.edu}
}
