% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSE.r
\name{rmse}
\alias{rmse}
\title{Root Mean Square Error (RMSE)}
\usage{
rmse(observed, predicted)
}
\arguments{
\item{observed}{a numeric vector of observed values}

\item{predicted}{a numeric vector of predicted values. The length shall be the same as for observed.}
}
\value{
the root mean square err or (RMSE) calculated from the observed and the predicted values.
}
\description{
Calculates the root mean square error (RMSE) from observed and predicted values.
}
\details{
rmse = sqrt(mean((observed - predicted)^2))
}
\examples{
o<-1:5
p<-c(2,2,4,3,5)
rmse(observed=o, predicted=p)
}
