% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{addImageQuery}
\alias{addImageQuery}
\title{Add image query functionality to leaflet/mapview map.}
\usage{
addImageQuery(
  map,
  x,
  band = 1,
  group = NULL,
  layerId = NULL,
  project = TRUE,
  type = c("mousemove", "click"),
  digits,
  position = "topright",
  prefix = "Layer",
  ...
)
}
\arguments{
\item{map}{the map with the RasterLayer to be queried.}

\item{x}{the RasterLayer that is to be queried.}

\item{band}{for stars layers, the band number to be queried.}

\item{group}{the group of the RasterLayer to be queried.}

\item{layerId}{the layerId of the RasterLayer to be queried. Needs to be the
same as supplied in \code{\link[leaflet]{addRasterImage}} or
\code{link{addStrasImage}}.}

\item{project}{whether to project the RasterLayer to conform with leaflets
expected crs. Defaults to \code{TRUE} and things are likely to go haywire
if set to \code{FALSE}.}

\item{type}{whether query should occur on 'mousemove' or 'click'. Defaults
to 'mousemove'.}

\item{digits}{the number of digits to be shown in the display field.}

\item{position}{where to place the display field. Default is 'topright'.}

\item{prefix}{a character string to be shown as prefix for the layerId.}

\item{...}{currently not used.}
}
\description{
Add image query functionality to leaflet/mapview map.
}
\details{
This function is deprecated.
Please use leafem::\code{\link[leafem]{addImageQuery}} instead.
}
