% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.AllGenerics.R
\name{march.thompson}
\alias{march.thompson}
\title{Thompson Confidence Intervals for a march.Model.}
\usage{
march.thompson(object, alpha)
}
\arguments{
\item{object}{the march.Model object on which compute the confidence intervals.}

\item{alpha}{the significance level among : 0.5, 0.4, 0.3, 0.2, 0.1, 0.05, 0.025, 0.02, 0.01, 0.005, 0.001, 0.0005, 0.0001.}
}
\value{
A list of half-length confidence intervals for each probability distribution of the considered model.
}
\description{
Compute the confidence intervals using Thompson's formula on a march.Model
object. See Thompson SK (1987) Sample size for estimating multinomial proportions,
American Statistician 41:42-46, for details.
}
\examples{
# Compute a first-order homogeneous Markov Chain for the pewee data.
MC1 <- march.mc.construct(pewee,1)
# Display the transition matrix
print(MC1@RC)
# Compute the half-length 95\% confidence interval for each row of the transition matrix.
march.thompson(MC1,alpha=0.05)

# Compute a third-order MTD model for the pewee data.
MTD3 <- march.mtd.construct(pewee,3)
# Display the model
print(MTD3)
# Compute the half-length 95\% confidence interval for the vector of lags
# and for each row of the transition matrix.
march.thompson(MTD3,alpha=0.05)
}
\author{
Ogier Maitre
}

