% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalmeans.R
\name{marginalmeans}
\alias{marginalmeans}
\title{Marginal Means}
\usage{
marginalmeans(model, variables = NULL, vcov = insight::get_varcov(model))
}
\arguments{
\item{model}{Model object}

\item{variables}{predictors over which to compute marginal means (character
vector). \code{NULL} calculates marginal means for all logical, character, or
factor variables in the dataset used to fit \code{model}.}

\item{vcov}{Matrix or boolean
\itemize{
\item FALSE: does not compute unit-level standard errors.
\item TRUE: computes unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item Named square matrix: computes standard errors with a user-supplied variance-covariance matrix. This matrix must be square and have dimensions equal to the number of coefficients in \code{get_coef(model)}.
}}
}
\value{
Data frame of marginal means with one row per variable-value
combination.
}
\description{
Compute estimated marginal means for specified factors.
}
\details{
This function begins by calling the \code{predictions} function to
obtain a grid of predictors, including cells for all combinations of all
categorical variables used to fit \code{model}, with numeric variables held at
their means. Then, it computes marginal means for the variables listed in
the \code{variables} argument.

The \code{marginaleffects} website compares the output of this function to the
popular \code{emmeans} package, which provides similar functionality and more
advanced options: https://vincentarelbundock.github.io/marginaleffects/
}
\examples{
library(marginaleffects)

# Convert numeric variables to categorical before fitting the model
dat <- mtcars
dat$cyl <- as.factor(dat$cyl)
dat$am <- as.logical(dat$am)
mod <- lm(mpg ~ hp + cyl + am, data = dat)

# Compute and summarize marginal means
mm <- marginalmeans(mod)
summary(mm)
}
