% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalmeans.R
\name{marginalmeans}
\alias{marginalmeans}
\title{Marginal Means}
\usage{
marginalmeans(
  model,
  variables = NULL,
  variables_grid = NULL,
  vcov = NULL,
  type = "response",
  ...
)
}
\arguments{
\item{model}{Model object}

\item{variables}{Categorical predictors over which to compute marginal means
(character vector). \code{NULL} calculates marginal means for all logical,
character, or factor variables in the dataset used to fit \code{model}.}

\item{variables_grid}{Categorical predictors used to construct the
prediction grid over which adjusted predictions are averaged (character
vector). \code{NULL} creates a grid with all combinations of all categorical
predictors. This grid can be very large when there are many variables and
many response levels, so it is advisable to select a limited number of
variables in the \code{variables} and \code{variables_grid} arguments.}

\item{vcov}{Matrix or boolean
\itemize{
\item FALSE: does not compute unit-level standard errors.
\item TRUE: computes unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item Named square matrix: computes standard errors with a user-supplied variance-covariance matrix. This matrix must be square and have dimensions equal to the number of coefficients in \code{get_coef(model)}.
}}

\item{type}{Type(s) of prediction as string or character vector. This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{...}{The "Model-Specific Arguments" section below gives a list of arguments which can modify the behavior of this function for certain models (e.g., mixed-effects or bayesian).}
}
\value{
Data frame of marginal means with one row per variable-value
combination.
}
\description{
Compute estimated marginal means for specified factors.
}
\details{
This function begins by calling the \code{predictions} function to obtain a
grid of predictors, and adjusted predictions for each cell. The grid
includes all combinations of the categorical variables listed in the
\code{variables} and \code{variables_grid} arguments, or all combinations of the
categorical variables used to fit the model if \code{variables_grid} is \code{NULL}.
In the prediction grid, numeric variables are held at their means.

After constructing the grid and filling the grid with adjusted predictions,
\code{marginalmeans} computes marginal means for the variables listed in the
\code{variables} argument, by average across all categories in the grid.

\code{marginalmeans} can only compute standard errors for linear models, or for
predictions on the link scale, that is, with the \code{type} argument set to
"link".

The \code{marginaleffects} website compares the output of this function to the
popular \code{emmeans} package, which provides similar but more advanced
functionality: https://vincentarelbundock.github.io/marginaleffects/
}
\section{Model-Specific Arguments}{


Some model types allow model-specific arguments to modify the nature of
marginal effects, predictions, marginal means, and contrasts.\tabular{llll}{
   Package \tab Class \tab Argument \tab Documentation \cr
   \code{brms} \tab \code{brmsfit} \tab \code{ndraws} \tab \link[brms:posterior_predict.brmsfit]{brms::posterior_predict} \cr
    \tab  \tab \code{re_formula} \tab  \cr
   \code{lme4} \tab \code{merMod} \tab \code{include_random} \tab \link[insight:get_predicted]{insight::get_predicted} \cr
    \tab  \tab \code{re.form} \tab \link[lme4:predict.merMod]{lme4::predict.merMod} \cr
    \tab  \tab \code{allow.new.levels} \tab \link[lme4:predict.merMod]{lme4::predict.merMod} \cr
    \tab  \tab \code{random.only} \tab \link[lme4:predict.merMod]{lme4::predict.merMod} \cr
}
}

\examples{
library(marginaleffects)

# Convert numeric variables to categorical before fitting the model
dat <- mtcars
dat$cyl <- as.factor(dat$cyl)
dat$am <- as.logical(dat$am)
mod <- lm(mpg ~ hp + cyl + am, data = dat)

# Compute and summarize marginal means
mm <- marginalmeans(mod)
summary(mm)
}
