% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.marginaleffects}
\alias{plot.marginaleffects}
\title{Point-range plot of average marginal effects}
\usage{
\method{plot}{marginaleffects}(x, conf_level = 0.95, ...)
}
\arguments{
\item{x}{An object produced by the \code{marginaleffects} function.}

\item{conf_level}{numeric value between 0 and 1. Confidence level to use to build a confidence interval.}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}
}
\value{
A \code{ggplot2} object
}
\description{
Uses the \code{ggplot2} package to draw a point-range plot of the average marginal effects computed by \code{tidy}.
}
\details{
The \code{tidy} function calculates average marginal effects by taking the mean
of all the unit-level marginal effects computed by the \code{marginaleffects}
function.

The standard error of the average marginal effects is obtained by
taking the mean of each column of the Jacobian. . Then, we use this
"Jacobian at the mean" in the Delta method to obtained standard errors.

In Bayesian models (e.g., \code{brms}), we compute Average Marginal
Effects by applying the mean function twice. First, we apply it to all
marginal effects for each posterior draw, thereby estimating one Average (or
Median) Marginal Effect per iteration of the MCMC chain. Second, we take
the \code{mean} and \code{quantile} function to the results of Step 1 to obtain the
Average (or Median) Marginal Effect and its associated interval.
}
\examples{
mod <- glm(am ~ hp + wt, data = mtcars)
mfx <- marginaleffects(mod)
plot(mfx)

}
\seealso{
Other plot: 
\code{\link{plot_cap}()},
\code{\link{plot_cco}()},
\code{\link{plot_cme}()}
}
\concept{plot}
