% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold.R
\name{kfold_disc}
\alias{kfold_disc}
\title{Create k disc based folds for cross-validation}
\usage{
kfold_disc(data, k = 5, lonlat = TRUE)
}
\arguments{
\item{data}{Matrix or dataframe. The first two columns should represent the
longitude and latitude (or x,y coordinates if \code{lonlat = FALSE}).}

\item{k}{Integer. The number of folds (partitions) that have to be created.
By default 5 folds are created.}

\item{lonlat}{Logical. If \code{TRUE} (default) then Great Circle distances
are calculated else if \code{FALSE} Euclidean (planar) distances are
calculated.}
}
\value{
A vector with fold numbers ranging from 1 to k.
}
\description{
\code{kfold_disc} creates a k-fold partitioning of geographical data for
cross-validation based on the distance between points. The n points nearest
to a selected point are put into a group. Returns a vector with fold numbers
ranging from 1 to k.
}
\examples{
set.seed(42)
lonlat_data <- cbind(runif(11, -180, 180), runif(11, -90, 90))
folds <- kfold_disc(lonlat_data, k = 5)
plot_folds(lonlat_data, folds)

# use the euclidean distance
xy_data <- cbind(runif(11, 0, 100), runif(11, 0, 100))
folds <- kfold_disc(xy_data, k = 5, lonlat = FALSE)
plot_folds(xy_data, folds)

}
\seealso{
\code{\link{plot_folds}}, \code{\link{kfold_grid}},
  \code{\link[dismo]{kfold}}, \code{\link{kfold_occurrence_background}}
}

