% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.R
\name{logic_ext}
\alias{logic_ext}
\alias{is_true}
\alias{is_false}
\alias{\%xor\%}
\alias{OR}
\alias{AND}
\alias{either}
\alias{is_boolean}
\alias{none}
\title{Logic - Extension'}
\usage{
is_true(x)

is_false(x)

x \%xor\% y

OR(..., na.rm = FALSE)

AND(..., na.rm = FALSE)

either(x, y)

is_boolean(x)

none(..., na.rm = FALSE)
}
\arguments{
\item{x, y}{A vector of logical values.  If \code{NULL} will generate a warning.  If
not a logical value, will return \code{NA} equal to the vector length}

\item{...}{Vectors or a list of logical values}

\item{na.rm}{Logical, if \code{TRUE} will ignore \code{NA}}
}
\value{
\itemize{
\item \code{is_true()}, \code{is_false()}, \code{either()}, \verb{\%or\%}, \code{AND()}, \code{OR()}: A \code{logical} vector, equal length of \code{x} (or \code{y} or of all \code{...} lengths)
\item \code{is_boolean()}: \code{TRUE} or \code{FALSE}
\item \code{none()}: \code{TRUE}, \code{FALSE}, or \code{NA}
}
}
\description{
All functions take logical or logical-like (i.e., 1, 0, or NA as integer or
doubles) and return logical values.

Extensions to the base logical operations to account for \code{NA} values.

\code{\link[base:Logic]{base::isTRUE()}} and \code{\link[base:Logic]{base::isFALSE()}} will only return single length \code{TRUE}
or \code{FALSE} as it checks for valid lengths in the evaluation.  When needing
to check over a vector for the presence of \code{TRUE} or \code{FALSE} and not being
held back by \code{NA} values, \code{is_true} and \code{is_false} will always provide a
\code{TRUE} \code{FALSE} when the vector is logical or return \code{NA} is the vector \code{x}
is not logical.

\verb{\%or\%} is just a wrapper for \code{\link[base:Logic]{base::xor()}}
}
\details{
Logical operations, extended
}
\examples{
x <- c(TRUE, FALSE, NA)
y <- c(FALSE, FALSE, TRUE)
z <- c(TRUE, NA, TRUE)
isTRUE(x)
is_true(x)
isFALSE(x)
is_false(x)
x \%xor\% TRUE
TRUE \%xor\% TRUE
TRUE \%xor\% FALSE
NA \%xor\% FALSE
OR(x, y, z)
OR(x, y, z, na.rm = TRUE)
AND(x, y, z)
AND(x, y, z, na.rm = TRUE)
either(x, FALSE)
either(TRUE, FALSE)
either(FALSE, NA)
either(TRUE, NA)
none(x)
none(x & y, na.rm = TRUE)
is_boolean(x)
is_boolean(c(1L, NA_integer_, 0L))
is_boolean(c(1.01, 0, -1))
}
