% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/diseq_basic.R,
%   R/diseq_deterministic_adjustment.R, R/diseq_directional.R,
%   R/diseq_stochastic_adjustment.R, R/equilibrium_model.R
\name{single_call_estimation}
\alias{single_call_estimation}
\alias{diseq_basic}
\alias{diseq_basic,formula-method}
\alias{diseq_deterministic_adjustment}
\alias{diseq_deterministic_adjustment,formula-method}
\alias{diseq_directional}
\alias{diseq_directional,formula-method}
\alias{diseq_stochastic_adjustment}
\alias{diseq_stochastic_adjustment,formula-method}
\alias{equilibrium_model}
\alias{equilibrium_model,formula-method}
\title{Single call estimation}
\usage{
diseq_basic(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

\S4method{diseq_basic}{formula}(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

diseq_deterministic_adjustment(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

\S4method{diseq_deterministic_adjustment}{formula}(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

diseq_directional(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

\S4method{diseq_directional}{formula}(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

diseq_stochastic_adjustment(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

\S4method{diseq_stochastic_adjustment}{formula}(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

equilibrium_model(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)

\S4method{equilibrium_model}{formula}(
  specification,
  data,
  correlated_shocks = TRUE,
  verbose = 0,
  estimation_options = list()
)
}
\arguments{
\item{specification}{The model's formula.}

\item{data}{The data to be used with the model.}

\item{correlated_shocks}{Should the model's system entail correlated shocks?
By default the argument is set to \code{TRUE}.}

\item{verbose}{The verbosity with which operations on the model print
messages. By default the value is set to \code{0}, which prints only errors.}

\item{estimation_options}{A list with options to be used in the estimation
call. See \code{\link[markets]{estimate}} for the available options.}
}
\value{
The fitted model.
}
\description{
Single call estimation
}
\details{
The functions of this section combine model initialization and estimation
into a single call. They also provide a less verbose interface to the
functionality of the package. The functions expect a formula following the
specification described in \link[=market_model_formula]{formula}, a
dataset, and optionally further initialization (see
\link[=model_initialization]{model initialization}) and
estimation (see \link[=estimate]{model estimation}) options.

Each of these functions parses the passed formula, initializes the model
specified by the function's name, fit the model to the passed data using
the estimation options and returns fitted model.
}
\section{Functions}{
\itemize{
\item \code{diseq_basic}: Basic disequilibrium model.

\item \code{diseq_deterministic_adjustment}: Disequilibrium model with deterministic
price adjustments.

\item \code{diseq_directional}: Directional disequilibrium model.

\item \code{diseq_stochastic_adjustment}: Disequilibrium model with stochastic
price adjustments.

\item \code{equilibrium_model}: Equilibrium model
}}

