% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_ctmcProbabilisticSAI.R
\name{probabilityatT}
\alias{probabilityatT}
\title{Calculating probability from a ctmc object}
\usage{
probabilityatT(C,t,x0,useRCpp)
}
\arguments{
\item{C}{A CTMC S4 object}

\item{t}{final time t}

\item{x0}{initial state}

\item{useRCpp}{logical whether to use RCpp implementation}
}
\value{
returns a vector or a matrix in case \code{x0} is provided or not respectively.
}
\description{
This function returns the probability of every state at time t under different conditions
}
\details{
The initial state is not mandatory, In case it is not provided, 
function returns a matrix of transition function at time \code{t} else it returns
vector of probaabilities of transition to different states if initial state was \code{x0}
}
\examples{
states <- c("a","b","c","d")
byRow <- TRUE
gen <- matrix(data = c(-1, 1/2, 1/2, 0, 1/4, -1/2, 0, 1/4, 1/6, 0, -1/3, 1/6, 0, 0, 0, 0),
nrow = 4,byrow = byRow, dimnames = list(states,states))
ctmc <- new("ctmc",states = states, byrow = byRow, generator = gen, name = "testctmc")
probabilityatT(ctmc,1,useRCpp = TRUE)

}
\references{
INTRODUCTION TO STOCHASTIC PROCESSES WITH R, ROBERT P. DOBROW, Wiley
}
\author{
Vandit Jain
}
